<?php

namespace Modules\Ebay\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Ebay\Entities\EbayOrder;
use Modules\Ebay\Entities\EbayOrderItem;

/**
 * @extends Factory<EbayOrderItem>
 */
class EbayOrderItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = EbayOrderItem::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'ebay_order_id' => EbayOrder::factory(),
            'json_object' => [
                'lineItemId' => $this->faker->randomNumber(),
                'legacyItemId' => $this->faker->randomNumber(),
                'sku' => $this->faker->word(),
            ],
        ];
    }
}
