<?php

namespace Modules\Ebay\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayLegacyProduct;

/**
 * @extends Factory<EbayLegacyProduct>
 */
class EbayLegacyProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = EbayLegacyProduct::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var EbayIntegrationInstance $ebayIntegrationInstance */
        $ebayIntegrationInstance = EbayIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $ebayIntegrationInstance->id,
            'json_object' => [
                'ItemID' => $this->faker->uuid,
                #'SKU' => $this->faker->uuid,
                'ListingDuration' => $this->faker->randomElement(['GTC', 'Days_30', 'Days_7', 'Days_1']),
                'ListingType' => $this->faker->randomElement(['FixedPriceItem', 'Chinese']),
                'Title' => $this->faker->sentence,
                'QuantityAvailable' => $this->faker->numberBetween(1, 100),
                'SellingStatus' => [
                    'CurrentPrice' => [
                        'value' => $this->faker->randomFloat(2, 1, 100),
                        'currencyID' => $this->faker->currencyCode,
                    ],
                ],
                'ListingStatus' => $this->faker->randomElement(['Active', 'Completed', 'Ended', 'EndedWithSales']),
                'BidCount' => $this->faker->numberBetween(0, 100),
                'EndingReason' => $this->faker->randomElement(['NotAvailable', 'LostOrBroken', 'Incorrect', 'OtherListingError']),
                'WatchCount' => $this->faker->numberBetween(0, 100),
                'StartTime' => $this->faker->dateTimeThisYear->format('Y-m-d H:i:s'),
                'StartTimeUtc' => $this->faker->dateTimeThisYear->format('Y-m-d H:i:s'),
                'EndTime' => $this->faker->dateTimeThisYear->format('Y-m-d H:i:s'),
                'EndTimeUtc' => $this->faker->dateTimeThisYear->format('Y-m-d H:i:s'),
            ],
        ];
    }
}
