<?php

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\Data\SalesChannelIntegrationSettingsData;
use App\Abstractions\Integrations\Data\StoreSalesChannelIntegrationDataInterface;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class UpdateEbayIntegrationData extends Data implements StoreSalesChannelIntegrationDataInterface
{
    public function __construct(
        public string|Optional $name,
        public EbayConnectionSettingsData|Optional $connection_settings,
        public SalesChannelIntegrationSettingsData|Optional $integration_settings,
        public bool|Optional $is_automatic_sync_enabled = false,
    )
    {
    }
}