<?php

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use App\Abstractions\Integrations\Data\AbstractSalesChannelData;
use Illuminate\Support\Optional;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;

class EbayResponseData extends Data implements ClientResponseDataInterface
{
    public function __construct(
        #[DataCollectionOf(AbstractSalesChannelData::class)]
        public DataCollection $collection,
        public Optional|string|null $nextEndpoint,
        public Optional|int|null $totalPages,
        public Optional|int|null $currentPage,
        public Optional|int|null $nextPage,
    ) {
    }
}
