<?php

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\Data\OauthAuthenticationAuthorizationResponseInterface;
use Spatie\LaravelData\Data;

class EbayAuthorizationResponseData extends Data implements OauthAuthenticationAuthorizationResponseInterface
{
    public function __construct(
        public string $state,
        public string $code,
    )
    {
    }

    public function getAuthCode(): string
    {
        return $this->code;
    }

    public function getAdditionalInfo(): array
    {
        return [];
    }
}
