<?php

namespace Modules\Ebay\Console;

use Modules\Ebay\Abstractions\AbstractEbayCommand;
use Modules\Ebay\ApiDataTransferObjects\EbayGetLegacyProductsAdt;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\RefreshEbayLegacyProductsJob;

class RefreshEbayLegacyProductsCommand extends AbstractEbayCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ebay:products:legacy:refresh 
        {integrationInstanceId?}
        {--all : Get All Listings Instead of just new ones}
    ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh Ebay Legacy Products';

    public function handle(): int
    {
        // TODO: Read ebay documentation to figure out how to get all listings (it probably isn't this call)
        // https://developer.ebay.com/support/kb-article?KBid=477
        // GetSellerList https://developer.ebay.com/devzone/xml/docs/reference/ebay/GetSellerList.html#Samples
        // Possibly need to use https://developer.ebay.com/DevZone/XML/docs/Reference/ebay/GetSellerEvents.html#GetSellerEvents
        // https://developer.ebay.com/support/kb-article?KBid=222 (good guide)
        // Challenge: finding a way to get only items modified after or created after a certain date
        // https://developer.ebay.com/api-docs/sell/feed/resources/inventory_task/methods/createInventoryTask - this only returns the sku and quantity avail
        /*
         * Current plan is to use GetMyEbaySelling to get list of items.  For updates... can use GetSellerEvents if updates are important...
         * If not, then can just use GetSellerList (passing the StartTimeFrom) to get new listings.  Instead of using GetSellerEvents to get updates, we
         * can always try to allow GetItem for individual listings needing updating... but there isn't really much action that is taken as a result... may as well just do GetSellerList
         * again for everything if needed (and only allow manual triggering).
         * This command can be used to get new listings only with a flag to get all listings
         */

        $parameters = new EbayGetLegacyProductsAdt(
            all: $this->option('all'),
        );

        $this->integrationInstances()
            ->each(function (EbayIntegrationInstance $ebayIntegrationInstance) use ($parameters) {
                //dispatch(new RefreshEbayLegacyProductsJob($ebayIntegrationInstance, $parameters))->onQueue('sales-channels');
                dispatch_sync(new RefreshEbayLegacyProductsJob($ebayIntegrationInstance, $parameters));
            });

        return 0;
    }
}
