<?php

namespace Modules\Ebay\Console;

use Illuminate\Console\Command;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\RefreshEbayLegacyProductsJob;

class MigrateEbayListings extends Command
{
    protected $signature = 'ebay:migrate:products {--integrationInstanceId=}';

    protected $description = 'Migrate Ebay Products';

    public function __construct(private readonly EbayIntegrationInstance $integrationInstanceRepository)
    {
        parent::__construct();
    }

    public function handle(): int
    {
        $integrationInstanceId = $this->option('integrationInstanceId');
        if ($integrationInstanceId) {
            $query = $this->integrationInstanceRepository->where('id', (int) $integrationInstanceId);
        } else {
            $query = $this->integrationInstanceRepository->all();
        }

        $this->info('Migrating Ebay Products for '.$query->count().' integrationInstances');

        $query
            ->each(function (EbayIntegrationInstance $ebayIntegrationInstance) {
                RefreshEbayLegacyProductsJob::dispatchSync($ebayIntegrationInstance);
            });

        return 0;
    }
}
