<?php

namespace Modules\Ebay\Console;

use Illuminate\Console\Command;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\CreateSkuProductsFromEbayProductsJob;
use Modules\Ebay\Repositories\EbayIntegrationInstanceRepository;

class CreateSkuProductsFromEbayProductsCommand extends Command
{
    protected $signature = 'ebay:products:create-sku-products {--integrationInstanceId=}';

    protected $description = 'Create SKU products from eBay products.';

    public function __construct(private readonly EbayIntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    public function handle(): int
    {
        $ebayIntegrationInstanceId = (int) $this->option('integrationInstanceId');

        if ($ebayIntegrationInstanceId) {
            $ebayIntegrationInstanceCollection = $this->integrationInstanceRepository->all($ebayIntegrationInstanceId);
        } else {
            $ebayIntegrationInstanceCollection = $this->integrationInstanceRepository->all();
        }

        $this->info(
            'Creating Ebay->SKU products for '.
            $ebayIntegrationInstanceCollection->count().' integration instances'
        );

        $ebayIntegrationInstanceCollection->each(function (EbayIntegrationInstance $ebayIntegrationInstance) {
            $this->info('Creating SKU products for integration instance: '.$ebayIntegrationInstance->id);
            dispatch_sync(
                new CreateSkuProductsFromEbayProductsJob($ebayIntegrationInstance)
            );
        });

        $this->info(
            'Completed SKU product creation from '.
            $ebayIntegrationInstanceCollection->count().' integration instances'
        );

        return self::SUCCESS;
    }
}
