<?php

namespace Modules\Ebay\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\ProductListing;
use Illuminate\Support\Collection;

class EbaySyncInventoryAdt implements ApiDataTransformerInterface
{

    public function __construct(
        public Collection $productListings,
    )
    {}

    public function transform(): array
    {
        // Transform the collection of product listings to groups of 4 of ItemID, Quantity
        return $this->productListings->flatMap(function (ProductListing $productListing) {
            return [
                [
                    'id' => $productListing->id,
                    'ItemID' => $productListing->sales_channel_listing_id,
                    'Quantity' => $productListing->quantity,
                ]
            ];
        })->chunk(4)->toArray();
    }
}