<?php

namespace Modules\Ebay\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Modules\Ebay\ApiDataTransferObjects\Concerns\EbayDatesTrait;

class EbayReviseItemAdt implements ApiDataTransformerInterface
{
    use EbayDatesTrait;

    public function __construct(
        public string $ItemID,
        public float $StartPrice,
        public string $Site,
    ) {
    }

    public function transform(): array
    {
       $params = [
           'ItemID' => $this->ItemID,
           'StartPrice' => $this->StartPrice,
              'Site' => $this->Site,
       ];

       return array_filter($params, fn ($param) => ! is_null($param));
    }
}
