<?php

namespace Modules\Ebay\ApiDataTransferObjects\Concerns;

use App\Helpers;
use Carbon\Carbon;

trait EbayDatesTrait
{
    public function setStartAndEndDateFromDays(int $days, $dateType): void
    {
        $this->{$dateType.'after'} = Carbon::now('UTC')->subDays($days);
        $this->{$dateType.'before'} = Carbon::now('UTC');
    }

    public function sanitizeDates(): void
    {
        foreach (self::DATES_TO_SANITIZE as $dateType) {
            if (is_string($this->{$dateType})) {
                $this->setDateFromLocalString($dateType, $this->{$dateType});
            }
        }
    }

    public function setDateFromLocalString(string $dateField, string $date): void
    {
        $this->{$dateField} = Helpers::dateLocalToUtc($date);
    }

    public function getZuluDate(string $dateField): ?string
    {
        return $this->{$dateField} ? $this->{$dateField}->format('Y-m-d\TH:i:s.v\Z') : null;
    }
}
