<?php

namespace Modules\Amazon\Tests\Seeders;

use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class SeedLedgerSummaries
{
    public static function seed(): void
    {
        $fnsku = 'B00KBTQ7D4';
        $msku = '1727569-FBA';
        $asin = 'B00KBTQ7D4';
        $title = 'Optimate 3, TM-431, 7-Step 12V 0.8A Sealed Battery Saving Charger & maintainer';
        $disposition = 'SELLABLE';
        $location = 'US';

        // Load file from current directory
        $fileContent = file_get_contents(__DIR__ . '/B00KBTQ7D4LedgerSummaries.csv');

        $lines = collect(explode(PHP_EOL, $fileContent));

        $headers = [];
        $lines->first(function ($line) use (&$headers) {
            $headers = str_getcsv($line);
            return true;
        });

        $report = AmazonReport::factory()->create();

        $integrationInstance = AmazonIntegrationInstance::first();

        $lines->skip(1)->each(function ($line) use (
            $headers,
            $integrationInstance,
            $fnsku,
            $msku,
            $asin,
            $title,
            $report,
            $disposition,
            $location
        ) {
            $values = str_getcsv($line);
            $row = array_combine($headers, $values);

            $data = [
                'integration_instance_id' => $integrationInstance->id,
                'event_datetime' => $row['event_datetime'],
                'amazon_report_id' => $report->id,
                'json_object' => [
                    'date' => $row['date'],
                    'fnsku' => $fnsku,
                    'msku' => $msku,
                    'asin' => $asin,
                    'title' => $title,
                    'starting_warehouse_balance' => $row['starting_warehouse_balance'],
                    'in_transit_between_warehouses' => $row['in_transit_between_warehouses'],
                    'receipts' => $row['receipts'],
                    'customer_shipments' => $row['customer_shipments'],
                    'customer_returns' => $row['customer_returns'],
                    'vendor_returns' => $row['vendor_returns'],
                    'warehouse_transfer_in_out' => $row['warehouse_transfer_in_out'],
                    'found' => $row['found'],
                    'lost' => $row['lost'],
                    'damaged' => $row['damaged'],
                    'disposed' => $row['disposed'],
                    'other_events' => $row['other_events'],
                    'ending_warehouse_balance' => $row['ending_warehouse_balance'],
                    'unknown_events' => $row['unknown_events'],
                    'reason' => null,
                    'disposition' => $disposition,
                    'location' => $location
                ]
            ];
            AmazonFbaReportInventoryLedgerSummary::create($data);
        });
    }
}