<?php

namespace Modules\Amazon\Tests\Feature\Managers;

use App\Models\AccountingTransaction;
use App\Models\SalesOrder;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\Amazon\Actions\InitializeFbaWarehouse;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class AmazonIntegrationInstanceManagerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private AmazonIntegrationInstance $amazonIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->amazonIntegrationInstance = AmazonIntegrationInstance::factory([
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => false,
            ],
        ])->hasSalesChannel()->create();

        (new InitializeFbaWarehouse($this->amazonIntegrationInstance))->handle();

        $this->amazonIntegrationInstance->refresh();
    }

    public function test_it_will_change_accounting_transactions_when_sync_sales_order_settings_changed(): void
    {
        $salesChannel = $this->amazonIntegrationInstance->salesChannel;

        $salesOrder = SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => false,
        ]);

        $settings                                              = $this->amazonIntegrationInstance->integration_settings;
        $settings['sync_sales_order_invoices_to_accounting']   = true;
        $this->amazonIntegrationInstance->integration_settings = $settings;
        $this->amazonIntegrationInstance->save();

        app(AccountingTransactionManager::class)->syncAccountingTransactionsSalesOrderIsSyncEnabledStatus($this->amazonIntegrationInstance);

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => true,
        ]);
    }
}