<?php

namespace Feature\Controllers;

use App\Models\NominalCode;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Modules\Amazon\Entities\AmazonFinancialEventTypeNominalCodeMapping;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Queue;
use Tests\TestCase;

/**
 * Ledgers are created from reports.  Set up should set up initial ledgers and initial inventory.
 */
class AmazonFinancialEventTypeNominalCodeMappingControllerTest extends TestCase
{
    use FastRefreshDatabase;

    private AmazonIntegrationInstance $integrationInstance;

    protected function setUp(): void
    {
        parent::setUp();
        Queue::fake();
        Sanctum::actingAs(User::first());

        $this->integrationInstance = AmazonIntegrationInstance::factory()
            ->hasSalesChannel()
            ->create();
    }

    public function test_amazon_financial_event_type_nominal_code_mapping_controller(): void
    {
        $financialEventTypeNominalCodeMapping = AmazonFinancialEventTypeNominalCodeMapping::factory()
            ->for($this->integrationInstance)
            ->create(['nominal_code_id' => null,
            ]);
        $nominalCode = NominalCode::query()->first();

        /*
        |--------------------------------------------------------------------------
        | Map nominal codes
        |--------------------------------------------------------------------------
        */

        $this->postJson(route('amazon.finances.nominal-code-mappings.store', [
            'integrationInstance' => $this->integrationInstance->id,
        ]), [
            'mappings' => [
                [
                    'nominal_code_id' => $nominalCode->id,
                    'id' => $financialEventTypeNominalCodeMapping->id,
                ],
            ],
        ])->assertOk();

        $this->assertDatabaseHas(AmazonFinancialEventTypeNominalCodeMapping::class, [
            'id' => $financialEventTypeNominalCodeMapping->id,
            'nominal_code_id' => $nominalCode->id,
        ]);

        /*
        |--------------------------------------------------------------------------
        | get nominal codes
        |--------------------------------------------------------------------------
        */

        $response = $this->getJson(route('amazon.finances.nominal-code-mappings.index', [
            'integrationInstance' => $this->integrationInstance->id,
        ]))->assertOk();

        $response->assertJsonCount(1, 'data');
    }
}
