<?php

namespace Modules\Amazon\Tests;

use Modules\Amazon\Enums\Entities\ReportProcessingStatusEnum;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

class AmazonTestingData
{
    public static function getProducts(): array
    {
        return [
            [
                'item_name' => 'TORC Motorcycle Gloves',
                'item_description' => '',
                'listing_id' => '0412VYTCLFO',
                'seller_sku' => '1123411-FBA',
                'price' => '64.99',
                'quantity' => '',
                'open_date' => '2019-04-12 10:58:19 PDT',
                'image_url' => '',
                'item_is_marketplace' => 'y',
                'product_id_type' => '1',
                'zshop_shipping_fee' => '',
                'item_note' => '',
                'item_condition' => '11',
                'zshop_category1' => '',
                'zshop_browse_path' => '',
                'zshop_storefront_feature' => '',
                'asin1' => 'B06XYT1MXV',
                'asin2' => '',
                'asin3' => '',
                'will_ship_internationally' => '',
                'expedited_shipping' => '',
                'zshop_boldface' => '',
                'product_id' => 'B06XYT1MXV',
                'bid_for_featured_placement' => '',
                'add_delete' => '',
                'pending_quantity' => '',
                'fulfillment_channel' => 'AMAZON_NA',
                'merchant_shipping_group' => 'Default Drop Shipper',
                'status' => 'Inactive',
            ],
            [
                'item_name' => 'Walbro GSS342-400-791 With Install Kit Fuel Pumps',
                'item_description' => '',
                'listing_id' => '0812XC33IHJ',
                'seller_sku' => '1124090',
                'price' => '105',
                'quantity' => '0',
                'open_date' => '2020-08-12 16:30:15 PDT',
                'image_url' => '',
                'item_is_marketplace' => 'y',
                'product_id_type' => '1',
                'zshop_shipping_fee' => '',
                'item_note' => '',
                'item_condition' => '11',
                'zshop_category1' => '',
                'zshop_browse_path' => '',
                'zshop_storefront_feature' => '',
                'asin1' => 'B000WCY80E',
                'asin2' => '',
                'asin3' => '',
                'will_ship_internationally' => '',
                'expedited_shipping' => '',
                'zshop_boldface' => '',
                'product_id' => 'B000WCY80E',
                'bid_for_featured_placement' => '',
                'add_delete' => '',
                'pending_quantity' => '0',
                'fulfillment_channel' => 'DEFAULT',
                'merchant_shipping_group' => 'Stock Flat Rate',
                'status' => 'Inactive',
            ],
        ];
    }

    public static function getOrders(): array
    {
        return [
            'payload' => [
                'Orders' => [
                    [
                        'BuyerInfo' => [
                            'BuyerEmail' => 'test@amazon.com',
                            'BuyerName' => 'Roy Rogers',
                        ],
                        'AmazonOrderId' => '112-1000437-1617009',
                        'EarliestDeliveryDate' => '2023-10-20T07:00:00Z',
                        'EarliestShipDate' => '2023-10-12T07:00:00Z',
                        'SalesChannel' => 'Amazon.com',
                        'AutomatedShippingSettings' => [
                            'HasAutomatedShippingSettings' => true,
                            'AutomatedShipMethodName' => 'ship-method-merchant-name-FEDEX_SMARTPOST',
                            'AutomatedCarrierName' => 'FedEx',
                        ],
                        'OrderStatus' => 'Shipped',
                        'NumberOfItemsShipped' => 1,
                        'OrderType' => 'StandardOrder',
                        'IsPremiumOrder' => false,
                        'IsPrime' => false,
                        'FulfillmentChannel' => 'MFN',
                        'NumberOfItemsUnshipped' => 0,
                        'HasRegulatedItems' => false,
                        'IsReplacementOrder' => 'false',
                        'IsSoldByAB' => false,
                        'LatestShipDate' => '2023-10-14T06:59:59Z',
                        'ShipServiceLevel' => 'Std US D2D Dom',
                        'DefaultShipFromLocationAddress' => [
                            'StateOrRegion' => 'NV',
                            'AddressLine1' => 'null',
                            'PostalCode' => '89030',
                            'City' => 'North Las Vegas',
                            'CountryCode' => 'US',
                            'Name' => 'null',
                        ],
                        'IsISPU' => false,
                        'MarketplaceId' => 'ATVPDKIKX0DER',
                        'LatestDeliveryDate' => '2023-10-24T06:59:59Z',
                        'PurchaseDate' => '2023-10-12T01:56:33Z',
                        'ShippingAddress' => [
                            'StateOrRegion' => 'IL',
                            'AddressLine1' => 'Amazon Address Line 1',
                            'PostalCode' => '60053-2908',
                            'City' => 'MORTON GROVE',
                            'CountryCode' => 'US',
                            'AddressType' => 'Residential',
                            'Name' => 'Roy Rogers',
                        ],
                        'IsAccessPointOrder' => false,
                        'SellerOrderId' => '182352',
                        'PaymentMethod' => 'Other',
                        'IsBusinessOrder' => false,
                        'OrderTotal' => ['CurrencyCode' => 'USD', 'Amount' => '986.74'],
                        'PaymentMethodDetails' => ['Standard'],
                        'IsGlobalExpressEnabled' => false,
                        'LastUpdateDate' => '2023-10-13T20:39:06Z',
                        'ShipmentServiceLevelCategory' => 'Standard',
                        'EarliestShipDateUtc' => '2023-10-12 07:00:00',
                        'LatestShipDateUtc' => '2023-10-14 06:59:59',
                        'PurchaseDateUtc' => '2023-10-12 01:56:33',
                        'LastUpdateDateUtc' => '2023-10-13 20:39:06',
                        'AmazonPurchaseDate' => '2023-10-11 18:56:33',
                    ],
                    [
                        'BuyerInfo' => [
                            'BuyerEmail' => 'test2@amazon.com',
                        ],
                        'AmazonOrderId' => '111-8840220-5362657',
                        'EarliestShipDate' => '2023-10-04T06:59:59Z',
                        'SalesChannel' => 'Amazon.com',
                        'OrderStatus' => 'Shipped',
                        'NumberOfItemsShipped' => 1,
                        'OrderType' => 'StandardOrder',
                        'IsPremiumOrder' => false,
                        'IsPrime' => false,
                        'FulfillmentChannel' => 'AFN',
                        'NumberOfItemsUnshipped' => 0,
                        'HasRegulatedItems' => false,
                        'IsReplacementOrder' => 'false',
                        'IsSoldByAB' => false,
                        'LatestShipDate' => '2023-10-04T06:59:59Z',
                        'ShipServiceLevel' => 'Expedited',
                        'IsISPU' => false,
                        'MarketplaceId' => 'ATVPDKIKX0DER',
                        'PurchaseDate' => '2023-10-04T01:01:01Z',
                        'ShippingAddress' => [
                            'StateOrRegion' => 'TN',
                            'PostalCode' => '37774-5614',
                            'City' => 'LOUDON',
                            'CountryCode' => 'US',
                            'Name' => null,
                        ],
                        'IsAccessPointOrder' => false,
                        'SellerOrderId' => '111-8840220-5362657',
                        'PaymentMethod' => 'Other',
                        'IsBusinessOrder' => false,
                        'OrderTotal' => ['CurrencyCode' => 'USD', 'Amount' => '135.16'],
                        'PaymentMethodDetails' => ['Standard'],
                        'IsGlobalExpressEnabled' => false,
                        'LastUpdateDate' => '2023-10-05T18:37:05Z',
                        'ShipmentServiceLevelCategory' => 'Expedited',
                        'EarliestShipDateUtc' => '2023-10-04 06:59:59',
                        'LatestShipDateUtc' => '2023-10-04 06:59:59',
                        'PurchaseDateUtc' => '2023-10-04 01:01:01',
                        'LastUpdateDateUtc' => '2023-10-05 18:37:05',
                        'AmazonPurchaseDate' => '2023-10-03 18:01:01',
                    ],
                ],
            ],
        ];
    }

    public static function getOrderItems(): array
    {
        return [
            'payload' => [
                'OrderItems' => [
                    [
                        'TaxCollection' => [
                            'Model' => 'MarketplaceFacilitator',
                            'ResponsibleParty' => 'Amazon Services, Inc.',
                        ],
                        'ProductInfo' => ['NumberOfItems' => '1'],
                        'BuyerInfo' => [],
                        'ItemTax' => ['CurrencyCode' => 'USD', 'Amount' => '0.72'],
                        'QuantityShipped' => 1,
                        'ItemPrice' => ['CurrencyCode' => 'USD', 'Amount' => '16.95'],
                        'ASIN' => 'B01N57XLNS',
                        'SellerSKU' => '1722590-FBA',
                        'Title' => 'Tecmate OptiMATE Cable O-40, Weatherproof SAE socket, panel mount',
                        'IsGift' => 'false',
                        'IsTransparency' => false,
                        'QuantityOrdered' => 1,
                        'PromotionDiscountTax' => ['CurrencyCode' => 'USD', 'Amount' => '0.00'],
                        'PromotionDiscount' => ['CurrencyCode' => 'USD', 'Amount' => '0.00'],
                        'OrderItemId' => '85170413581441',
                        'ShippingPrice' => [
                            'Amount' => 5.00,
                        ],
                    ],
                    [
                        'TaxCollection' => [
                            'Model' => 'MarketplaceFacilitator',
                            'ResponsibleParty' => 'Amazon Services, Inc.',
                        ],
                        'ProductInfo' => ['NumberOfItems' => '1'],
                        'BuyerInfo' => [],
                        'ItemTax' => ['CurrencyCode' => 'USD', 'Amount' => '0.98'],
                        'QuantityShipped' => 1,
                        'ItemPrice' => ['CurrencyCode' => 'USD', 'Amount' => '22.95'],
                        'ASIN' => 'B09JXYZJGD',
                        'SellerSKU' => '2944600-FBA',
                        'Title' => 'Tecmate Optimate Cable O-20L, Weatherproof SAE Socket, Front Panel Mount, Black',
                        'IsGift' => 'false',
                        'IsTransparency' => false,
                        'QuantityOrdered' => 1,
                        'PromotionDiscountTax' => ['CurrencyCode' => 'USD', 'Amount' => '0.00'],
                        'PromotionDiscount' => ['CurrencyCode' => 'USD', 'Amount' => '0.00'],
                        'OrderItemId' => '85170413581481',
                    ],
                ],
            ],
        ];
    }

    public static function getRefreshTokenFromAuthCode(): array
    {
        return [
            'refresh_token' => 'refresh token',
            'access_token' => 'access token',
            'selling_partner_id' => 'selling partner id',
        ];
    }

    public static function getAccessToken(): array
    {
        return [
            'access_token' => 'access token',
        ];
    }

    public static function getRestrictedDataToken(): array
    {
        return [
            'restrictedDataToken' => 'restricted data token',
        ];
    }

    public static function createReport(): array
    {
        return [
            'reportId' => 123,
        ];
    }

    public static function createCAReport(): array
    {
        return [
            'reportId' => 456,
        ];
    }

    public static function createMXReport(): array
    {
        return [
            'reportId' => 789,
        ];
    }

    public static function createBRReport(): array
    {
        return [
            'reportId' => 99,
        ];
    }

    public static function getReportUSInProgress(): array
    {
        return [
            "reportType" => AmazonReportTypeEnum::PRODUCTS->value,
            "processingStatus" => ReportProcessingStatusEnum::IN_PROGRESS->value,
            "marketplaceIds" => ["ATVPDKIKX0DER"],
            "reportId" => "123",
            "dataEndTime" => "2023-12-20T03:00:03+00:00",
            "createdTime" => "2023-12-23T03:01:06+00:00",
            "processingStartTime" => "2023-12-23T03:01:13+00:00",
            "dataStartTime" => "2023-12-11T03:00:04+00:00",
        ];
    }

    public static function getReportCAInProgress(): array
    {
        return [
            "reportType" => AmazonReportTypeEnum::PRODUCTS->value,
            "processingStatus" => ReportProcessingStatusEnum::IN_PROGRESS->value,
            "marketplaceIds" => ["A2EUQ1WTGCTBG2"],
            "reportId" => "456",
            "dataEndTime" => "2023-12-20T03:00:03+00:00",
            "createdTime" => "2023-12-23T03:01:06+00:00",
            "processingStartTime" => "2023-12-23T03:01:13+00:00",
            "dataStartTime" => "2023-12-11T03:00:04+00:00",
        ];
    }

    public static function getReportMXInProgress(): array
    {
        return [
            "reportType" => AmazonReportTypeEnum::PRODUCTS->value,
            "processingStatus" => ReportProcessingStatusEnum::IN_PROGRESS->value,
            "marketplaceIds" => ["A1AM78C64UM0Y8"],
            "reportId" => "789",
            "dataEndTime" => "2023-12-20T03:00:03+00:00",
            "createdTime" => "2023-12-23T03:01:06+00:00",
            "processingStartTime" => "2023-12-23T03:01:13+00:00",
            "dataStartTime" => "2023-12-11T03:00:04+00:00",
        ];
    }

    public static function getReportBRInProgress(): array
    {
        return [
            "reportType" => AmazonReportTypeEnum::PRODUCTS->value,
            "processingStatus" => ReportProcessingStatusEnum::IN_PROGRESS->value,
            "marketplaceIds" => ["A2Q3Y263D00KWC"],
            "reportId" => "999",
            "dataEndTime" => "2023-12-20T03:00:03+00:00",
            "createdTime" => "2023-12-23T03:01:06+00:00",
            "processingStartTime" => "2023-12-23T03:01:13+00:00",
            "dataStartTime" => "2023-12-11T03:00:04+00:00",
        ];
    }

    public static function getReportUSDone(): array
    {
        return [
            "reportType" => AmazonReportTypeEnum::PRODUCTS->value,
            "processingEndTime" => "2023-12-23T03:01:27+00:00",
            "processingStatus" => ReportProcessingStatusEnum::DONE->value,
            "marketplaceIds" => ["ATVPDKIKX0DER"],
            "reportDocumentId" =>
                "amzn1.spdoc.1.4.na.6dfb6e3c-b70d-4670-bc7b-1d8b2dc6c739.T1TS811JACNAHJ.2661",
            "reportId" => "123",
            "dataEndTime" => "2023-12-20T03:00:03+00:00",
            "createdTime" => "2023-12-23T03:01:06+00:00",
            "processingStartTime" => "2023-12-23T03:01:13+00:00",
            "dataStartTime" => "2023-12-11T03:00:04+00:00",
        ];
    }

    public static function getReportUSDocument(): array
    {
        return [
            'url' => 'https://123',
        ];
    }

    public static function getCatalogData(): array
    {
        return [
            'numberOfResults' => 2,
            'items' => [
                [
                    'asin' => 'B06XYT1MXV',
                    'attributes' => [
                        'bullet_point' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Converts the MV Agusta diagnostic connector to an OptiMate SAE battery charger connector.',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Ideal for OptiMate 1, 2, 3, 4 and OptiMate 6 battery chargers.',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Fuse protected, with weatherproof cap and seal for SAE connector.',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Cable rated for use from 60°C / 140°F down to -40°C/-40°F - Remains Flexible below freezing!',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Premium cable - Built to last!',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'item_package_quantity' => [
                            ['value' => 1, 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                        'item_dimensions' => [
                            [
                                'width' => ['unit' => 'inches', 'value' => 2.28],
                                'length' => ['unit' => 'inches', 'value' => 6.22],
                                'height' => ['unit' => 'inches', 'value' => 2.09],
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'brand' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Tecmate',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'input_voltage' => [
                            [
                                'unit' => 'volts',
                                'value' => 240,
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'package_level' => [
                            ['value' => 'unit', 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                        'item_type_keyword' => [
                            [
                                'value' => 'booster-cables',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'item_package_dimensions' => [
                            [
                                'length' => ['unit' => 'centimeters', 'value' => 5.7],
                                'width' => ['unit' => 'centimeters', 'value' => 6.2],
                                'height' => ['unit' => 'centimeters', 'value' => 17],
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'size' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Motorcycle',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'warranty_description' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => '3 Years',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'part_number' => [
                            ['value' => 'O-57', 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                        'style' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'OptiMATE ADAPTER: MOTORCYCLE, SAE to MV AGUSTA',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'pesticide_marking' => [
                            [
                                'marking_type' => 'epa_registration_number',
                                'registration_status' => 'fifra_not_considered_pesticide',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'marking_type' => 'epa_establishment_number',
                                'registration_status' => 'fifra_not_considered_pesticide',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'color' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Black',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'item_package_weight' => [
                            [
                                'unit' => 'kilograms',
                                'value' => 0.087,
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'manufacturer' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'SynchroMate',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'externally_assigned_product_identifier' => [
                            [
                                'value' => '5425006142991',
                                'type' => 'ean',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'value' => '7613018954130',
                                'type' => 'ean',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'value' => '05425006142991',
                                'type' => 'gtin',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'model_number' => [
                            ['value' => 'O-57', 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                        'supplier_declared_dg_hz_regulation' => [
                            [
                                'value' => 'not_applicable',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'california_proposition_65' => [
                            [
                                'compliance_type' => 'on_product_combined_cancer_reproductive',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                            [
                                'compliance_type' => 'chemical',
                                'chemical_names' => ['lead'],
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'item_name' => [
                            [
                                'language_tag' => 'en_US',
                                'value' => 'Tecmate Optimate Cable O-57, Adapter, MV Agusta Port to SAE Plug',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'list_price' => [
                            [
                                'currency' => 'USD',
                                'value' => 13.9,
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'batteries_required' => [
                            ['value' => false, 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                        'street_date' => [
                            [
                                'value' => '2015-05-22T00:00:01Z',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'product_site_launch_date' => [
                            [
                                'value' => '2014-12-31T20:51:54.356Z',
                                'marketplace_id' => 'ATVPDKIKX0DER',
                            ],
                        ],
                        'batteries_included' => [
                            ['value' => false, 'marketplace_id' => 'ATVPDKIKX0DER'],
                        ],
                    ],
                    'dimensions' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'item' => [
                                'height' => ['unit' => 'inches', 'value' => 2.09],
                                'length' => ['unit' => 'inches', 'value' => 6.22],
                                'width' => ['unit' => 'inches', 'value' => 2.28],
                            ],
                            'package' => [
                                'height' => [
                                    'unit' => 'inches',
                                    'value' => 2.2440944859,
                                ],
                                'length' => [
                                    'unit' => 'inches',
                                    'value' => 6.692913379,
                                ],
                                'weight' => [
                                    'unit' => 'pounds',
                                    'value' => 0.19180216794,
                                ],
                                'width' => [
                                    'unit' => 'inches',
                                    'value' => 2.4409448794,
                                ],
                            ],
                        ],
                    ],
                    'identifiers' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'identifiers' => [
                                [
                                    'identifierType' => 'EAN',
                                    'identifier' => '5425006142991',
                                ],
                                [
                                    'identifierType' => 'EAN',
                                    'identifier' => '7613018954130',
                                ],
                                [
                                    'identifierType' => 'GTIN',
                                    'identifier' => '05425006142991',
                                ],
                            ],
                        ],
                    ],
                    'images' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'images' => [
                                [
                                    'variant' => 'MAIN',
                                    'link' => 'https://m.media-amazon.com/images/I/61AsUoVSmfL.jpg',
                                    'height' => 1500,
                                    'width' => 1500,
                                ],
                                [
                                    'variant' => 'MAIN',
                                    'link' => 'https://m.media-amazon.com/images/I/31+ZKFwmIFL.jpg',
                                    'height' => 500,
                                    'width' => 500,
                                ],
                                [
                                    'variant' => 'MAIN',
                                    'link' => 'https://m.media-amazon.com/images/I/31+ZKFwmIFL._SL75_.jpg',
                                    'height' => 75,
                                    'width' => 75,
                                ],
                                [
                                    'variant' => 'PT01',
                                    'link' => 'https://m.media-amazon.com/images/I/61diA05rZHL.jpg',
                                    'height' => 1500,
                                    'width' => 1500,
                                ],
                                [
                                    'variant' => 'PT01',
                                    'link' => 'https://m.media-amazon.com/images/I/31awLsibKqL.jpg',
                                    'height' => 500,
                                    'width' => 500,
                                ],
                                [
                                    'variant' => 'PT01',
                                    'link' => 'https://m.media-amazon.com/images/I/31awLsibKqL._SL75_.jpg',
                                    'height' => 75,
                                    'width' => 75,
                                ],
                                [
                                    'variant' => 'PT02',
                                    'link' => 'https://m.media-amazon.com/images/I/61UWXGLsRpL.jpg',
                                    'height' => 1500,
                                    'width' => 1500,
                                ],
                                [
                                    'variant' => 'PT02',
                                    'link' => 'https://m.media-amazon.com/images/I/31t8-Nf45kL.jpg',
                                    'height' => 500,
                                    'width' => 500,
                                ],
                                [
                                    'variant' => 'PT02',
                                    'link' => 'https://m.media-amazon.com/images/I/31t8-Nf45kL._SL75_.jpg',
                                    'height' => 75,
                                    'width' => 75,
                                ],
                                [
                                    'variant' => 'PT03',
                                    'link' => 'https://m.media-amazon.com/images/I/4124vMXHnxL.jpg',
                                    'height' => 1145,
                                    'width' => 220,
                                ],
                                [
                                    'variant' => 'PT03',
                                    'link' => 'https://m.media-amazon.com/images/I/218denmpKFL.jpg',
                                    'height' => 500,
                                    'width' => 96,
                                ],
                                [
                                    'variant' => 'PT03',
                                    'link' => 'https://m.media-amazon.com/images/I/218denmpKFL._SL75_.jpg',
                                    'height' => 75,
                                    'width' => 14,
                                ],
                            ],
                        ],
                    ],
                    'productTypes' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'productType' => 'BATTERY_CHARGER',
                        ],
                    ],
                    'relationships' => [
                        ['marketplaceId' => 'ATVPDKIKX0DER', 'relationships' => []],
                    ],
                    'salesRanks' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'classificationRanks' => [
                                [
                                    'classificationId' => '15719931',
                                    'title' => 'Automotive Replacement Battery Accessories',
                                    'link' => 'https://www.amazon.com/gp/bestsellers/automotive/15719931',
                                    'rank' => 3442,
                                ],
                            ],
                            'displayGroupRanks' => [
                                [
                                    'websiteDisplayGroup' => 'automotive_display_on_website',
                                    'title' => 'Automotive',
                                    'link' => 'https://www.amazon.com/gp/bestsellers/automotive',
                                    'rank' => 512945,
                                ],
                            ],
                        ],
                    ],
                    'summaries' => [
                        [
                            'marketplaceId' => 'ATVPDKIKX0DER',
                            'adultProduct' => false,
                            'autographed' => false,
                            'brand' => 'Tecmate',
                            'browseClassification' => [
                                'displayName' => 'Battery Accessories',
                                'classificationId' => '15719931',
                            ],
                            'color' => 'Black',
                            'itemClassification' => 'BASE_PRODUCT',
                            'itemName' => 'Tecmate Optimate Cable O-57, Adapter, MV Agusta Port to SAE Plug',
                            'manufacturer' => 'SynchroMate',
                            'memorabilia' => false,
                            'modelNumber' => 'O-57',
                            'packageQuantity' => 1,
                            'partNumber' => 'O-57',
                            'releaseDate' => '2015-05-22',
                            'size' => 'Motorcycle',
                            'style' => 'OptiMATE ADAPTER: MOTORCYCLE, SAE to MV AGUSTA',
                            'tradeInEligible' => false,
                            'websiteDisplayGroup' => 'automotive_display_on_website',
                            'websiteDisplayGroupName' => 'Automotive Parts and Accessories',
                        ],
                    ],
                ],
                [
                    'asin' => 'B000WCY80E',
                    'catalog_data' => [
                        'asin' => 'B000WCY80E',
                        'attributes' => [
                            'item_weight' => [
                                [
                                    'unit' => 'pounds',
                                    'value' => 0.5,
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'bullet_point' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => '255 LPH',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Fuel Pump and Install Kit',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Subaru WRX (02-05)',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'specification_met' => [
                                [
                                    'language_tag' => 'en_US',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'item_package_quantity' => [
                                ['value' => 1, 'marketplace_id' => 'ATVPDKIKX0DER'],
                            ],
                            'product_description' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => '(255 LPH) Built for the (02-05) Subaru WRX... Walbro in-tank electric fuel pumps utilize a proven gerotor design. The outside dimensions, however, are compact enough to fit existing hanger assemblies, without modification. These are complete fuel pump kits with the pump and include all drop parts, accessories and installation instructions. Also included is an inlet filter that meets or exceeds original equipment specifications and provides improved filtration and durability.',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'brand' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Walbro',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'fit_type' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Universal Fit',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'item_type_keyword' => [
                                [
                                    'value' => 'automotive-electric-fuel-pumps',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'number_of_items' => [
                                ['value' => 1, 'marketplace_id' => 'ATVPDKIKX0DER'],
                            ],
                            'item_package_dimensions' => [
                                [
                                    'length' => ['unit' => 'centimeters', 'value' => 5.588],
                                    'width' => ['unit' => 'centimeters', 'value' => 15.24],
                                    'height' => ['unit' => 'centimeters', 'value' => 16.256],
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'part_number' => [
                                [
                                    'value' => 'GSS342-400-791',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'style' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Modern',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'item_package_weight' => [
                                [
                                    'unit' => 'kilograms',
                                    'value' => 0.45400000000000007,
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'manufacturer' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Walbro',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'model_number' => [
                                [
                                    'value' => 'GSS342-400-791',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'supplier_declared_dg_hz_regulation' => [
                                [
                                    'value' => 'not_applicable',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'operation_mode' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Electric',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'item_name' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Walbro GSS342-400-791 With Install Kit Fuel Pumps',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'list_price' => [
                                [
                                    'currency' => 'USD',
                                    'value' => 169.5,
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'batteries_required' => [
                                ['value' => false, 'marketplace_id' => 'ATVPDKIKX0DER'],
                            ],
                            'product_site_launch_date' => [
                                [
                                    'value' => '2006-02-01T08:00:01-00:00',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'material' => [
                                [
                                    'language_tag' => 'en_US',
                                    'value' => 'Metal',
                                    'marketplace_id' => 'ATVPDKIKX0DER',
                                ],
                            ],
                            'batteries_included' => [
                                ['value' => false, 'marketplace_id' => 'ATVPDKIKX0DER'],
                            ],
                        ],
                        'dimensions' => [
                            [
                                'marketplaceId' => 'ATVPDKIKX0DER',
                                'item' => ['weight' => ['unit' => 'pounds', 'value' => 0.5]],
                                'package' => [
                                    'height' => ['unit' => 'inches', 'value' => 2.199999997756],
                                    'length' => ['unit' => 'inches', 'value' => 6.399999993472],
                                    'weight' => [
                                        'unit' => 'pounds',
                                        'value' => 1.0008986694800002,
                                    ],
                                    'width' => ['unit' => 'inches', 'value' => 5.99999999388],
                                ],
                            ],
                        ],
                        'identifiers' => [
                            ['marketplaceId' => 'ATVPDKIKX0DER', 'identifiers' => []],
                        ],
                        'images' => [
                            [
                                'marketplaceId' => 'ATVPDKIKX0DER',
                                'images' => [
                                    [
                                        'variant' => 'MAIN',
                                        'link' => 'https://m.media-amazon.com/images/I/31VJTINIpSL.jpg',
                                        'height' => 384,
                                        'width' => 500,
                                    ],
                                    [
                                        'variant' => 'MAIN',
                                        'link' => 'https://m.media-amazon.com/images/I/31VJTINIpSL._SL75_.jpg',
                                        'height' => 58,
                                        'width' => 75,
                                    ],
                                    [
                                        'variant' => 'MAIN',
                                        'link' => 'https://m.media-amazon.com/images/I/61Fbwgr2omL.jpg',
                                        'height' => 1152,
                                        'width' => 1500,
                                    ],
                                    [
                                        'variant' => 'PT01',
                                        'link' => 'https://m.media-amazon.com/images/I/31n7nEri12L.jpg',
                                        'height' => 500,
                                        'width' => 500,
                                    ],
                                    [
                                        'variant' => 'PT01',
                                        'link' => 'https://m.media-amazon.com/images/I/31n7nEri12L._SL75_.jpg',
                                        'height' => 75,
                                        'width' => 75,
                                    ],
                                    [
                                        'variant' => 'PT01',
                                        'link' => 'https://m.media-amazon.com/images/I/61dpNBbP45L.jpg',
                                        'height' => 1500,
                                        'width' => 1500,
                                    ],
                                    [
                                        'variant' => 'PT02',
                                        'link' => 'https://m.media-amazon.com/images/I/51yp4jnlTpL.jpg',
                                        'height' => 624,
                                        'width' => 885,
                                    ],
                                    [
                                        'variant' => 'PT02',
                                        'link' => 'https://m.media-amazon.com/images/I/51yp4jnlTpL._SL75_.jpg',
                                        'height' => 53,
                                        'width' => 75,
                                    ],
                                    [
                                        'variant' => 'PT03',
                                        'link' => 'https://m.media-amazon.com/images/I/41vGsipO+ZL.jpg',
                                        'height' => 500,
                                        'width' => 386,
                                    ],
                                    [
                                        'variant' => 'PT03',
                                        'link' => 'https://m.media-amazon.com/images/I/41vGsipO+ZL._SL75_.jpg',
                                        'height' => 75,
                                        'width' => 58,
                                    ],
                                    [
                                        'variant' => 'PT03',
                                        'link' => 'https://m.media-amazon.com/images/I/61R3IVgspQL.jpg',
                                        'height' => 1600,
                                        'width' => 1236,
                                    ],
                                    [
                                        'variant' => 'PT04',
                                        'link' => 'https://m.media-amazon.com/images/I/415bdZdzXjL.jpg',
                                        'height' => 500,
                                        'width' => 386,
                                    ],
                                    [
                                        'variant' => 'PT04',
                                        'link' => 'https://m.media-amazon.com/images/I/415bdZdzXjL._SL75_.jpg',
                                        'height' => 75,
                                        'width' => 58,
                                    ],
                                    [
                                        'variant' => 'PT04',
                                        'link' => 'https://m.media-amazon.com/images/I/71FL7uq0UpL.jpg',
                                        'height' => 1600,
                                        'width' => 1236,
                                    ],
                                    [
                                        'variant' => 'PT05',
                                        'link' => 'https://m.media-amazon.com/images/I/41Ap9DrSuNL.jpg',
                                        'height' => 354,
                                        'width' => 500,
                                    ],
                                    [
                                        'variant' => 'PT05',
                                        'link' => 'https://m.media-amazon.com/images/I/41Ap9DrSuNL._SL75_.jpg',
                                        'height' => 53,
                                        'width' => 75,
                                    ],
                                    [
                                        'variant' => 'PT05',
                                        'link' => 'https://m.media-amazon.com/images/I/61Nw-UydXdL.jpg',
                                        'height' => 869,
                                        'width' => 1229,
                                    ],
                                ],
                            ],
                        ],
                        'productTypes' => [
                            ['marketplaceId' => 'ATVPDKIKX0DER', 'productType' => 'FUEL_PUMP'],
                        ],
                        'relationships' => [
                            ['marketplaceId' => 'ATVPDKIKX0DER', 'relationships' => []],
                        ],
                        'salesRanks' => [
                            [
                                'marketplaceId' => 'ATVPDKIKX0DER',
                                'classificationRanks' => [
                                    [
                                        'classificationId' => '15728151',
                                        'title' => 'Automotive Replacement Electric Fuel Pumps',
                                        'link' => 'https://www.amazon.com/gp/bestsellers/automotive/15728151',
                                        'rank' => 1280,
                                    ],
                                ],
                                'displayGroupRanks' => [
                                    [
                                        'websiteDisplayGroup' => 'automotive_display_on_website',
                                        'title' => 'Automotive',
                                        'link' => 'https://www.amazon.com/gp/bestsellers/automotive',
                                        'rank' => 232045,
                                    ],
                                ],
                            ],
                        ],
                        'summaries' => [
                            [
                                'marketplaceId' => 'ATVPDKIKX0DER',
                                'adultProduct' => false,
                                'autographed' => false,
                                'brand' => 'Walbro',
                                'browseClassification' => [
                                    'displayName' => 'Electric Fuel Pumps',
                                    'classificationId' => '15728151',
                                ],
                                'itemClassification' => 'BASE_PRODUCT',
                                'itemName' => 'Walbro GSS342-400-791 With Install Kit Fuel Pumps',
                                'manufacturer' => 'Walbro',
                                'memorabilia' => false,
                                'modelNumber' => 'GSS342-400-791',
                                'packageQuantity' => 1,
                                'partNumber' => 'GSS342-400-791',
                                'style' => 'Modern',
                                'tradeInEligible' => false,
                                'websiteDisplayGroup' => 'automotive_display_on_website',
                                'websiteDisplayGroupName' => 'Automotive Parts and Accessories',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public static function getInboundShipments(): array
    {
        return [
            'payload' => [
                'ShipmentData' => [
                    [
                        'ShipmentId' => 'FBA17LS62V61',
                        'ShipmentName' => 'FBA 2023-12-21 08:09:21 - 2',
                        'ShipFromAddress' => [
                            'Name' => 'AIMS Power',
                            'AddressLine1' => '9550 Gateway Dr.',
                            'City' => 'Reno',
                            'StateOrProvinceCode' => 'NV',
                            'CountryCode' => 'US',
                            'PostalCode' => '89521',
                        ],
                        'DestinationFulfillmentCenterId' => 'SLC2',
                        'ShipmentStatus' => 'WORKING',
                        'LabelPrepType' => 'SELLER_LABEL',
                        'BoxContentsSource' => 'FEED',
                    ],
                    [
                        'ShipmentId' => 'FBA17LS62V5D',
                        'ShipmentName' => 'FBA 2023-12-21 08:09:21 - 1',
                        'ShipFromAddress' => [
                            'Name' => 'Warehouse ABC',
                            'AddressLine1' => '9550 Gateway Dr.',
                            'City' => 'Reno',
                            'StateOrProvinceCode' => 'NV',
                            'CountryCode' => 'US',
                            'PostalCode' => '89521',
                        ],
                        'DestinationFulfillmentCenterId' => 'SMF3',
                        'ShipmentStatus' => 'WORKING',
                        'LabelPrepType' => 'SELLER_LABEL',
                        'BoxContentsSource' => 'FEED',
                    ],
                ],
                'NextToken' => 'AAAAAAAAAABd0jNWq972DFjCnoIOEzjw2AEAAAAAAABjBOpzf6hxdbQnbAo97RVlRcaLiU44goz0FvWNlWV1YKaSXjwBcB/K/RIp0kqDiBmtEGBD4VKCRZSxgDXqSDeHVzvKRe8G93jmTYHKECw9QtqjWC6Q8+Zf2Tkn5zUjYVn8ODdyrTmTlo8457u/FeYPtkyJt6zPCCpJEcUCGg5UKP2aDJqd9hzME6s7viCHj+R+BWu/WuzJkUwRYCM9lO+D7Ll6lLkN5u5zLp5OPWemWHiGyQRDiFLtCRjQcAN3BXLq1fxJtkeodFVwWBnTVpBdeOqNnm7POCGyZlvwIjeQznv7CmFGLcMz+HaoNY4Sr1eeUo/sVE/yMVMdYqcGH52RLANfsIt6x7dqEICFtBWZeMV2RypMfIeq4jzuCPHQ1FU67mfn4RAgM9i6mUs3ltVTPMouHcikvVLlRSlmgEyTK0jFflS0DI0A0zL0t2SfADIjtn2ww2E1+ZF+qbJyMJLkf0shqNQ10P7Hx5OjPz/8QayUd85vAwUiWVBcbKDdPEb/rIsLBk5WW2mwdgg1+tiCnzrLACjhmCW3qgbLJsjuo2cKucvbFXEHNsCVxAXm/XOxxUTnexMTzYMxRq5iGvBfveeFOByuU4J/ZG+YjAHm6kt+NkBgxVEd',
            ],
        ];
    }

    public static function getInboundShipmentItems(): array
    {
        return [
            'payload' => [
                'ItemData' => [
                    [
                        'ShipmentId' => 'FBA17LS62V61',
                        'SellerSKU' => '2955489-FBA',
                        'FulfillmentNetworkSKU' => 'X003DG2ZIT',
                        'QuantityShipped' => 3,
                        'QuantityReceived' => 0,
                        'QuantityInCase' => 0,
                        'ReleaseDate' => '2016-04-11',
                        'PrepDetailsList' => [
                            ['PrepInstruction' => 'Labeling', 'PrepOwner' => 'SELLER'],
                        ],
                    ],
                    [
                        'ShipmentId' => 'FBA17LS62V61',
                        'SellerSKU' => '2955455-FBA',
                        'FulfillmentNetworkSKU' => 'X003DG2ZIT2',
                        'QuantityShipped' => 2,
                        'QuantityReceived' => 0,
                        'QuantityInCase' => 0,
                        'ReleaseDate' => '2016-04-11',
                        'PrepDetailsList' => [
                            ['PrepInstruction' => 'Labeling', 'PrepOwner' => 'SELLER'],
                        ],
                    ],
                ],
                'NextToken' => 'AAAAAAAAAABd0jNWq972DFjCnoIOEzjwUgEAAAAAAAChFZ6QyMmESQtFpwOECC9R3LLMD16ouaGr7U3atI7HFTxNb77vRJOCU/GthVZsOQ0MXxTl5ThCvnskZWBD0trkDfjSHfDAzbdrCk9XnWLj9J3IucJPBkjr8/x6Xpu3ySh6aGpMFKtFwt/qCgXhN3rHuzDQFL6GHnbvvdsOv6ez7Scey1oat5zV2wBD1KrknZPq2tDgCJLN3R7U1URn55Ubzao5awgZIs3tdTpEfVFuym9KurI8ygCuQX2RVWnIuCldJYQ33ALRG+ulSHz1eF85fLQtm3VPTzd1a9qfgplccWQXdC7PRI+KeJsnpSvr/37Wk/0f1XL8//1/MlYE7Cwx+RmRMYbw9W7y7aAjRkGGlBCzfZsNw9xAg7u7E6CtMlG0s4XXZIQO9s32eDkqS4X+WB617idO0ygciAVKVJcG903CDPeqeJ1mlLtelMM/og9ANg==',
            ],
        ];
    }

    public static function listInboundPlans(): array
    {
        return [
            "inboundPlans" => [
                [
                    "createdAt" => "2024-05-30T09:05:43Z",
                    "marketplaceIds" => ["ATVPDKIKX0DER"],
                    "sourceAddress" => [
                        "phoneNumber" => "1 844 337 2095",
                        "city" => "Buffalo",
                        "countryCode" => "US",
                        "postalCode" => "14207",
                        "name" => "AIMS Power",
                        "addressLine1" => "2299 Kenmore Ave.",
                        "stateOrProvinceCode" => "NY",
                        "email" => "orders-usa@tecmate.com",
                    ],
                    "lastUpdatedAt" => "2024-05-31T12:01:08Z",
                    "name" => "AIMS Inbound Order 20240506 - Speed",
                    "inboundPlanId" => "wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57",
                    "status" => "SHIPPED",
                ],
                [
                    "createdAt" => "2024-06-08T14:00:16Z",
                    "marketplaceIds" => ["ATVPDKIKX0DER"],
                    "sourceAddress" => [
                        "phoneNumber" => "7608808820",
                        "city" => "North Las Vegas",
                        "countryCode" => "US",
                        "postalCode" => "89030",
                        "name" => "Warehouse ABC",
                        "addressLine1" => "4031 Industrial Center Dr. Ste. 705",
                        "stateOrProvinceCode" => "NV",
                    ],
                    "lastUpdatedAt" => "2024-06-10T15:10:40Z",
                    "name" => "Warehouse ABC Inbound Order 20240608",
                    "inboundPlanId" => "wf52bdb8a9-d197-4d95-9f60-07d2293b587d",
                    "status" => "ACTIVE",
                ],
            ],
            "pagination" => [],
        ];
    }

    public static function listInboundPlanItems1(): array
    {
        return [
            "pagination" => [],
            "items" => [
                [
                    "labelOwner" => "",
                    "msku" => "1727519-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
                [
                    "labelOwner" => "",
                    "msku" => "1727520-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT2",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
            ],
        ];
    }

    public static function listInboundPlanItems2(): array
    {
        return [
            "pagination" => [],
            "items" => [
                [
                    "labelOwner" => "",
                    "msku" => "1727519-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
                [
                    "labelOwner" => "",
                    "msku" => "1727520-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT2",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
            ],
        ];
    }

    public static function getInboundPlan1(): array
    {
        return [
            "createdAt" => "2024-05-30T09:05:43Z",
            "marketplaceIds" => ["ATVPDKIKX0DER"],
            "sourceAddress" => [
                "phoneNumber" => "1 844 337 2095",
                "city" => "Buffalo",
                "countryCode" => "US",
                "postalCode" => "14207",
                "name" => "AIMS Power",
                "addressLine1" => "2299 Kenmore Ave.",
                "stateOrProvinceCode" => "NY",
                "email" => "orders-usa@tecmate.com",
            ],
            "lastUpdatedAt" => "2024-05-31T12:01:08Z",
            "name" => "AIMS Inbound Order 20240506 - Speed",
            "inboundPlanId" => "wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57",
            "status" => "SHIPPED",
            "shipments" => [
                [
                    "shipmentId" => "sh520dd36b-ba96-4943-bb94-c733489b94d4",
                    "status" => "RECEIVING"
                ],
            ]
        ];
    }

    public static function getInboundPlan2(): array
    {
        return [
            "createdAt" => "2024-06-08T14:00:16Z",
            "marketplaceIds" => ["ATVPDKIKX0DER"],
            "sourceAddress" => [
                "phoneNumber" => "7608808820",
                "city" => "North Las Vegas",
                "countryCode" => "US",
                "postalCode" => "89030",
                "name" => "Warehouse ABC",
                "addressLine1" => "4031 Industrial Center Dr. Ste. 705",
                "stateOrProvinceCode" => "NV",
            ],
            "lastUpdatedAt" => "2024-06-10T15:10:40Z",
            "name" => "Warehouse ABC Inbound Order 20240608",
            "inboundPlanId" => "wf52bdb8a9-d197-4d95-9f60-07d2293b587d",
            "status" => "ACTIVE",
            "packingOptions" => [
                "packingOptionId" => "po00000000-0000-0000-0000-000000000000",
                "status" => "ACCEPTED"
            ],
            "placementOptions" => [
                "placementOptionId" => "pld0e6abe4-4c8f-43da-80e5-deefa65a5396",
                "status" => "ACCEPTED"
            ],
            "shipments" => [
                [
                    "shipmentId" => "she29cf4f2-dfda-4d7d-a783-82f2a63c472d",
                    "status" => "CLOSED"
                ]
            ]
        ];
    }

    public static function getNewInboundShipment1(): array
    {
        return [
            "selectedTransportationOptionId" =>
                "to19885b0f-cb01-4f6f-904f-55b3b116858a",
            "shipmentId" => "sh520dd36b-ba96-4943-bb94-c733489b94d4",
            "amazonReferenceId" => "51B5PMLN",
            "destination" => [
                "address" => [
                    "city" => "Charlotte",
                    "countryCode" => "US",
                    "postalCode" => "28214-8082",
                    "name" => "Amazon.com Services, Inc.",
                    "addressLine1" => "10240 Old Dowd Rd",
                    "stateOrProvinceCode" => "NC",
                ],
                "warehouseId" => "CLT2",
                "destinationType" => "AMAZON_WAREHOUSE",
            ],
            "name" => "FBA STA (05/30/2024 11:01)-CLT2",
            "shipmentConfirmationId" => "FBA17LS62V5D",
            "source" => [
                "address" => [
                    "phoneNumber" => "1 844 337 2095",
                    "city" => "Buffalo",
                    "countryCode" => "US",
                    "postalCode" => "14207",
                    "name" => "AIMS Power",
                    "addressLine1" => "2299 Kenmore Ave.",
                    "stateOrProvinceCode" => "NY",
                    "email" => "orders-usa@tecmate.com",
                ],
                "sourceType" => "SELLER_FACILITY",
            ],
            "placementOptionId" => "pld0e6abe4-4c8f-43da-80e5-deefa65a5396",
            "status" => "RECEIVING",
        ];
    }

    public static function getNewInboundShipment2(): array
    {
        return [
            "selectedTransportationOptionId" =>
                "to19885b0f-cb01-4f6f-904f-55b3b116858a",
            "shipmentId" => "she29cf4f2-dfda-4d7d-a783-82f2a63c472d",
            "amazonReferenceId" => "51B5PMLN",
            "destination" => [
                "address" => [
                    "city" => "Charlotte",
                    "countryCode" => "US",
                    "postalCode" => "28214-8082",
                    "name" => "Amazon.com Services, Inc.",
                    "addressLine1" => "10240 Old Dowd Rd",
                    "stateOrProvinceCode" => "NC",
                ],
                "warehouseId" => "CLT2",
                "destinationType" => "AMAZON_WAREHOUSE",
            ],
            "name" => "FBA STA (05/30/2024 11:01)-CLT2",
            "shipmentConfirmationId" => "FBA17LS62V61",
            "source" => [
                "address" => [
                    "phoneNumber" => "7608808820",
                    "city" => "North Las Vegas",
                    "countryCode" => "US",
                    "postalCode" => "89030",
                    "name" => "Warehouse ABC",
                    "addressLine1" => "4031 Industrial Center Dr. Ste. 705",
                    "stateOrProvinceCode" => "NV",
                ],
                "sourceType" => "SELLER_FACILITY",
            ],
            "placementOptionId" => "pld0e6abe4-4c8f-43da-80e5-deefa65a5396",
            "status" => "RECEIVING",
        ];
    }

    public static function listShipmentItems1(): array
    {
        return [
            "pagination" => [],
            "items" => [
                [
                    "labelOwner" => "NONE",
                    "msku" => "1727519-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
                [
                    "labelOwner" => "NONE",
                    "msku" => "1727520-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT2",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
            ],
        ];
    }

    public static function listShipmentItems2(): array
    {
        return [
            "pagination" => [],
            "items" => [
                [
                    "labelOwner" => "SELLER",
                    "msku" => "2294584-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT",
                    "asin" => "B07R1MKK4B",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                        ["prepType" => "ITEM_LABELING", "prepOwner" => "SELLER"],
                    ],
                ],
                [
                    "labelOwner" => "NONE",
                    "msku" => "1727520-FBA",
                    "quantity" => 5,
                    "fnsku" => "X003DG2ZIT2",
                    "asin" => "B005DUM9OM",
                    "prepInstructions" => [
                        ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                    ],
                ],
            ],
        ];
    }

    public static function listInboundShipmentBoxes(): array
    {
        return [
            "boxes" => [
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B2",
                    "packageId" => "pk00a5dca5-c004-4925-8a59-33b65781e584",
                    "weight" => ["unit" => "LB", "value" => 17],
                    "items" => [
                        [
                            "labelOwner" => "",
                            "msku" => "2956061-FBA",
                            "quantity" => 2,
                            "fnsku" => "B0BFBXTDQR",
                            "asin" => "B0BFBXTDQR",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727526-FBA",
                            "quantity" => 24,
                            "fnsku" => "B00Z9PO8DQ",
                            "asin" => "B00Z9PO8DQ",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2923970-FBA-1",
                            "quantity" => 10,
                            "fnsku" => "X002UQZEKJ",
                            "asin" => "B075RDDW84",
                            "prepInstructions" => [
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2948139-FBA",
                            "quantity" => 10,
                            "fnsku" => "X003507QQ9",
                            "asin" => "B09R4VZLS5",
                            "prepInstructions" => [
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727517-FBA-2",
                            "quantity" => 10,
                            "fnsku" => "B004PPZSEE",
                            "asin" => "B004PPZSEE",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000002",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 20,
                        "width" => 20,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B11",
                    "packageId" => "pk0565d406-6194-47b6-8653-6179a1cf1041",
                    "weight" => ["unit" => "LB", "value" => 24],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "1727565-FBA-1",
                            "quantity" => 12,
                            "fnsku" => "X002E963MZ",
                            "asin" => "B001EBDXLM",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000011",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 16,
                        "width" => 13,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B6",
                    "packageId" => "pk0b2c0ae2-cf17-423d-8451-6314b1b8e3a5",
                    "weight" => ["unit" => "LB", "value" => 27],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2904285-FBA-1",
                            "quantity" => 15,
                            "fnsku" => "X002P2SWGV",
                            "asin" => "B011J76CFE",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000006",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 14,
                        "width" => 14,
                        "height" => 15,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B8",
                    "packageId" => "pk2ec035a6-9adc-4e3a-b643-5923c0f5f7e8",
                    "weight" => ["unit" => "LB", "value" => 10],
                    "items" => [
                        [
                            "labelOwner" => "",
                            "msku" => "2958057-FBA",
                            "quantity" => 3,
                            "fnsku" => "B0BFBXCV4C",
                            "asin" => "B0BFBXCV4C",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000008",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 12,
                        "width" => 12,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B10",
                    "packageId" => "pk4556e74e-e282-4459-a80c-44e026b3909a",
                    "weight" => ["unit" => "LB", "value" => 34],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2904285-FBA",
                            "quantity" => 18,
                            "fnsku" => "X002OWBXK9",
                            "asin" => "B08CHCBZN3",
                            "prepInstructions" => [
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000010",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 20,
                        "width" => 20,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B3",
                    "packageId" => "pk642425c5-7f63-475c-b142-a85e26ba6a5d",
                    "weight" => ["unit" => "LB", "value" => 16],
                    "items" => [
                        [
                            "labelOwner" => "",
                            "msku" => "1727591-FBA",
                            "quantity" => 10,
                            "fnsku" => "B008S9LEU0",
                            "asin" => "B008S9LEU0",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727531-FBA",
                            "quantity" => 10,
                            "fnsku" => "B008S9LG5I",
                            "asin" => "B008S9LG5I",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2968014-FBA",
                            "quantity" => 10,
                            "fnsku" => "X003XNPNBN",
                            "asin" => "B0C8LR2YGV",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727552-FBA",
                            "quantity" => 10,
                            "fnsku" => "B00Y38WRSI",
                            "asin" => "B00Y38WRSI",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727559-FBA",
                            "quantity" => 10,
                            "fnsku" => "B01K86F9M4",
                            "asin" => "B01K86F9M4",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000003",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 18,
                        "width" => 14,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B1",
                    "packageId" => "pk94402bcb-728b-4aff-b186-a39062049efa",
                    "weight" => ["unit" => "LB", "value" => 23],
                    "items" => [
                        [
                            "labelOwner" => "",
                            "msku" => "1727519-FBA",
                            "quantity" => 10,
                            "fnsku" => "B005DUM9OM",
                            "asin" => "B005DUM9OM",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727591-FBA",
                            "quantity" => 20,
                            "fnsku" => "B008S9LEU0",
                            "asin" => "B008S9LEU0",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2888600-FBA-1",
                            "quantity" => 30,
                            "fnsku" => "X002P2PKTD",
                            "asin" => "B0885XN37B",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2888598-FBA-1",
                            "quantity" => 20,
                            "fnsku" => "X002O7CNB7",
                            "asin" => "B074KLP22Z",
                            "prepInstructions" => [
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000001",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 20,
                        "width" => 20,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B9",
                    "packageId" => "pka56873af-e9d1-477d-8e1f-d947b80d99f8",
                    "weight" => ["unit" => "LB", "value" => 34],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2888602-FBA",
                            "quantity" => 10,
                            "fnsku" => "X002MO733Z",
                            "asin" => "B08GG9C28Q",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000009",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 17,
                        "width" => 16,
                        "height" => 17,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B7",
                    "packageId" => "pkcbb37df7-a1b4-47a5-8189-9cb196b6b685",
                    "weight" => ["unit" => "LB", "value" => 13],
                    "items" => [
                        [
                            "labelOwner" => "",
                            "msku" => "2917214-FBA-1",
                            "quantity" => 4,
                            "fnsku" => "B08W8J7RK2",
                            "asin" => "B08W8J7RK2",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000007",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 12,
                        "width" => 12,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B5",
                    "packageId" => "pkd4afd4f9-20ff-4796-a5ca-90a1da6c799b",
                    "weight" => ["unit" => "LB", "value" => 7],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2924598-FBA",
                            "quantity" => 2,
                            "fnsku" => "X002V0FN87",
                            "asin" => "B00JTUUGEC",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2968014-FBA",
                            "quantity" => 3,
                            "fnsku" => "X003XNPNBN",
                            "asin" => "B0C8LR2YGV",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727583-FBA",
                            "quantity" => 6,
                            "fnsku" => "B00JTUUN9K",
                            "asin" => "B00JTUUN9K",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727553-FBA",
                            "quantity" => 10,
                            "fnsku" => "B00Y38X0FC",
                            "asin" => "B00Y38X0FC",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727541-FBA",
                            "quantity" => 2,
                            "fnsku" => "B008S9LGFS",
                            "asin" => "B008S9LGFS",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000005",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 14,
                        "width" => 14,
                        "height" => 14,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
                [
                    "quantity" => 1,
                    "templateName" => "P1 - B4",
                    "packageId" => "pkdb65b6bf-635d-48ae-af06-0a4e3d71ee4c",
                    "weight" => ["unit" => "LB", "value" => 11],
                    "items" => [
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "2294584-FBA",
                            "quantity" => 5,
                            "fnsku" => "X002E2XLP9",
                            "asin" => "B07R1MKK4B",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727542-FBA",
                            "quantity" => 10,
                            "fnsku" => "B008S9LG3U",
                            "asin" => "B008S9LG3U",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727514-FBA",
                            "quantity" => 5,
                            "fnsku" => "B0022ZSBR0",
                            "asin" => "B0022ZSBR0",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "SELLER",
                            "msku" => "1727550-FBA",
                            "quantity" => 5,
                            "fnsku" => "X001WE3OGL",
                            "asin" => "B00Y38WJPY",
                            "prepInstructions" => [
                                [
                                    "prepType" => "ITEM_LABELING",
                                    "prepOwner" => "SELLER",
                                ],
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                        [
                            "labelOwner" => "",
                            "msku" => "1727547-FBA",
                            "quantity" => 10,
                            "fnsku" => "B00Y38WZYY",
                            "asin" => "B00Y38WZYY",
                            "prepInstructions" => [
                                ["prepType" => "ITEM_NO_PREP", "prepOwner" => "SELLER"],
                            ],
                        ],
                    ],
                    "boxId" => "FBA182CPJVJZU000004",
                    "dimensions" => [
                        "unitOfMeasurement" => "IN",
                        "length" => 18,
                        "width" => 14,
                        "height" => 12,
                    ],
                    "contentInformationSource" => "BOX_CONTENT_PROVIDED",
                ],
            ],
            "pagination" => [],
        ];
    }

    public static function getFulfillmentOrder(): array
    {
        return [
            'payload' => [
                'fulfillmentOrder' => [
                    'sellerFulfillmentOrderId' => '123.1',
                    'marketplaceId' => 'ATVPDKIKX0DER',
                    'displayableOrderId' => '123',
                    'displayableOrderDate' => '2024-05-13T15:22:40Z',
                    'displayableOrderComment' => 'Thank you for your order!',
                    'shippingSpeedCategory' => 'Standard',
                    'destinationAddress' => [
                        'name' => 'Jennifer Adams',
                        'addressLine1' => '618 Thompson St',
                        'city' => 'Irving',
                        'stateOrRegion' => 'TX',
                        'countryCode' => 'US',
                        'postalCode' => '75061-7219',
                    ],
                    'fulfillmentAction' => 'Ship',
                    'fulfillmentPolicy' => 'FillOrKill',
                    'receivedDate' => '2024-05-13T15:22:41Z',
                    'fulfillmentOrderStatus' => 'Complete',
                    'statusUpdatedDate' => '2024-05-14T01:14:59Z',
                    'notificationEmails' => [],
                    'featureConstraints' => [
                        [
                            'featureName' => 'BLANK_BOX',
                            'featureFulfillmentPolicy' => 'NotRequired',
                        ],
                    ],
                ],
                'fulfillmentOrderItems' => [
                    [
                        'sellerSku' => '2291979-FBA-1',
                        'sellerFulfillmentOrderItemId' => '3173',
                        'quantity' => '1',
                        'fulfillmentNetworkSku' => 'X002DO6E57',
                        'orderItemDisposition' => 'Sellable',
                        'cancelledQuantity' => '0',
                        'unfulfillableQuantity' => '0',
                        'estimatedShipDate' => '2024-05-14T06:59:59Z',
                        'estimatedArrivalDate' => '2024-05-17T02:59:00Z',
                        'perUnitDeclaredValue' => [
                            'currencyCode' => 'USD',
                            'value' => '39.95',
                        ],
                    ],
                ],
                'fulfillmentShipments' => [
                    [
                        'amazonShipmentId' => 'GH6BlBVxF',
                        'fulfillmentCenterId' => 'DSM5',
                        'fulfillmentShipmentStatus' => 'SHIPPED',
                        'shippingDate' => '2024-05-14T01:14:45Z',
                        'estimatedArrivalDate' => '2024-05-16T06:59:59Z',
                        'fulfillmentShipmentItem' => [
                            [
                                'sellerSku' => '2291979-FBA-1',
                                'sellerFulfillmentOrderItemId' => '3173',
                                'quantity' => '1',
                                'packageNumber' => '480203741',
                            ],
                        ],
                        'fulfillmentShipmentPackage' => [
                            [
                                'packageNumber' => '480203741',
                                'carrierCode' => 'Amazon Logistics',
                                'trackingNumber' => 'TBA313166722760',
                                'estimatedArrivalDate' => '2024-05-16T03:00:00Z',
                            ],
                        ],
                    ],
                ],
                'returnItems' => [],
                'returnAuthorizations' => [],
                'paymentInformation' => [],
            ],
        ];
    }

    public static function listAllFulfillmentOrders(): array
    {
        return [
            'payload' => [
                'fulfillmentOrders' => [
                    [
                        'sellerFulfillmentOrderId' => '123.1',
                        'displayableOrderId' => '123',
                        'displayableOrderDate' => '2024-05-13T15:22:40Z',
                        'displayableOrderComment' => 'Thank you for your order!',
                        'shippingSpeedCategory' => 'Standard',
                        'destinationAddress' => [
                            'name' => 'Jennifer Adams',
                            'addressLine1' => '618 Thompson St',
                            'city' => 'Irving',
                            'stateOrRegion' => 'TX',
                            'countryCode' => 'US',
                            'postalCode' => '75061-7219',
                        ],
                        'fulfillmentPolicy' => 'FillOrKill',
                        'receivedDate' => '2024-05-13T15:22:41Z',
                        'fulfillmentOrderStatus' => 'Complete',
                        'statusUpdatedDate' => '2024-05-13T18:47:41Z',
                        'featureConstraints' => [
                            [
                                'featureName' => 'BLANK_BOX',
                                'featureFulfillmentPolicy' => 'NotRequired',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function getFinancialEvents()
    {
        return [
            'payload' => [
                'FinancialEvents' => [
                    'ShipmentEventList' => [
                        [
                            'AmazonOrderId' => '113-4971496-4949056',
                            'SellerOrderId' => '113-4971496-4949056',
                            'MarketplaceName' => 'Amazon.com',
                            'PostedDate' => '2024-06-08T16:17:33Z',
                            'ShipmentItemList' => [
                                [
                                    'SellerSKU' => '922941-FBA',
                                    'OrderItemId' => '101671838096641',
                                    'QuantityShipped' => 1,
                                    'ItemChargeList' => [
                                        [
                                            'ChargeType' => 'Principal',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 106.25,
                                            ],
                                        ],
                                        [
                                            'ChargeType' => 'Tax',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 7.44,
                                            ],
                                        ],
                                        [
                                            'ChargeType' => 'GiftWrap',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'ChargeType' => 'GiftWrapTax',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'ChargeType' => 'ShippingCharge',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'ChargeType' => 'ShippingTax',
                                            'ChargeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                    ],
                                    'ItemFeeList' => [
                                        [
                                            'FeeType' => 'FBAPerOrderFulfillmentFee',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'FBAPerUnitFulfillmentFee',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => -14.37,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'FBAWeightBasedFee',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'Commission',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => -12.75,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'FixedClosingFee',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'GiftwrapChargeback',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'ShippingChargeback',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                        [
                                            'FeeType' => 'VariableClosingFee',
                                            'FeeAmount' => [
                                                'CurrencyCode' => 'USD',
                                                'CurrencyAmount' => 0,
                                            ],
                                        ],
                                    ],
                                    'ItemTaxWithheldList' => [
                                        [
                                            'TaxCollectionModel' => 'MarketplaceFacilitator',
                                            'TaxesWithheld' => [
                                                [
                                                    'ChargeType' => 'MarketplaceFacilitatorTax-Principal',
                                                    'ChargeAmount' => [
                                                        'CurrencyCode' => 'USD',
                                                        'CurrencyAmount' => -7.44,
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    'ShipmentSettleEventList' => [
                    ],
                    'RefundEventList' => [
                    ],
                    'GuaranteeClaimEventList' => [
                    ],
                    'ChargebackEventList' => [
                    ],
                    'PayWithAmazonEventList' => [
                    ],
                    'ServiceProviderCreditEventList' => [
                    ],
                    'RetrochargeEventList' => [
                    ],
                    'RentalTransactionEventList' => [
                    ],
                    'PerformanceBondRefundEventList' => [
                    ],
                    'ProductAdsPaymentEventList' => [
                    ],
                    'ServiceFeeEventList' => [
                    ],
                    'SellerDealPaymentEventList' => [
                    ],
                    'DebtRecoveryEventList' => [
                    ],
                    'LoanServicingEventList' => [
                    ],
                    'AdjustmentEventList' => [
                    ],
                    'SAFETReimbursementEventList' => [
                    ],
                    'SellerReviewEnrollmentPaymentEventList' => [
                    ],
                    'FBALiquidationEventList' => [
                    ],
                    'CouponPaymentEventList' => [
                    ],
                    'ImagingServicesFeeEventList' => [
                    ],
                    'NetworkComminglingTransactionEventList' => [
                    ],
                    'AffordabilityExpenseEventList' => [
                    ],
                    'AffordabilityExpenseReversalEventList' => [
                    ],
                    'RemovalShipmentEventList' => [
                    ],
                    'RemovalShipmentAdjustmentEventList' => [
                    ],
                    'TrialShipmentEventList' => [
                    ],
                    'TDSReimbursementEventList' => [
                    ],
                    'AdhocDisbursementEventList' => [
                    ],
                    'TaxWithholdingEventList' => [
                    ],
                    'ChargeRefundEventList' => [
                    ],
                    'FailedAdhocDisbursementEventList' => [
                    ],
                    'ValueAddedServiceChargeEventList' => [
                    ],
                    'CapacityReservationBillingEventList' => [
                    ],
                ],
            ],
        ];

    }

    public static function getMarketplaceParticipations(): array
    {
        return [
            "payload" => [
                [
                    "marketplace" => [
                        "id" => "A1AM78C64UM0Y8",
                        "countryCode" => "MX",
                        "name" => "Amazon.com.mx",
                        "defaultCurrencyCode" => "MXN",
                        "defaultLanguageCode" => "es_MX",
                        "domainName" => "www.amazon.com.mx",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A1MQXOICRS2Z7M",
                        "countryCode" => "CA",
                        "name" => "SI CA Prod Marketplace",
                        "defaultCurrencyCode" => "CAD",
                        "defaultLanguageCode" => "en_CA",
                        "domainName" => "siprod.stores.amazon.ca",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A2EUQ1WTGCTBG2",
                        "countryCode" => "CA",
                        "name" => "Amazon.ca",
                        "defaultCurrencyCode" => "CAD",
                        "defaultLanguageCode" => "en_CA",
                        "domainName" => "www.amazon.ca",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A2Q3Y263D00KWC",
                        "countryCode" => "BR",
                        "name" => "Amazon.com.br",
                        "defaultCurrencyCode" => "BRL",
                        "defaultLanguageCode" => "pt_BR",
                        "domainName" => "www.amazon.com.br",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A2ZV50J4W1RKNI",
                        "countryCode" => "US",
                        "name" => "Non-Amazon",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "sim1.stores.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A3BXB0YN3XH17H",
                        "countryCode" => "US",
                        "name" => "Amazon Pay Sandbox",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "apa-sandbox.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A3H6HPSLHAK3XG",
                        "countryCode" => "MX",
                        "name" => "Non-Amazon",
                        "defaultCurrencyCode" => "MXN",
                        "defaultLanguageCode" => "es_MX",
                        "domainName" => "sidevo.stores.amazon.mx",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "A6W85IYQ5WB1C",
                        "countryCode" => "US",
                        "name" => "IBA",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "iba.login.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "AGWSWK15IEJJ7",
                        "countryCode" => "US",
                        "name" => "Amazon Pay",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "apa.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "AHRY1CZE9ZY4H",
                        "countryCode" => "US",
                        "name" => "Amazon.com Invoicing Shadow Marketplace",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "invoicing-shadow-marketplace.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
                [
                    "marketplace" => [
                        "id" => "ATVPDKIKX0DER",
                        "countryCode" => "US",
                        "name" => "Amazon.com",
                        "defaultCurrencyCode" => "USD",
                        "defaultLanguageCode" => "en_US",
                        "domainName" => "www.amazon.com",
                    ],
                    "participation" => [
                        "isParticipating" => true,
                        "hasSuspendedListings" => false,
                    ],
                ],
            ],
        ];
    }
}
