<?php

namespace Modules\Amazon\Services;

use App\Enums\HttpMethodEnum;
use App\Exceptions\ApiException;
use Illuminate\Http\Client\ConnectionException;
use Modules\Amazon\Data\AmazonCatalogItemData;
use Modules\Amazon\Exceptions\AmazonTimeoutException;
use Spatie\LaravelData\DataCollection;

class AmazonProductClient extends AmazonAuthenticationClient
{
    /**
     * Get information about a catalog item.
     *
     * @throws Exception
     */
    public function getCatalogItem(string $asin): ?AmazonCatalogItemData
    {
        $response = $this->request(HttpMethodEnum::GET, '/catalog/2022-04-01/items', [
            'identifiers' => $asin,
            'identifiersType' => 'ASIN',
            'marketplaceIds' => $this->integrationInstance->getMarketplaceIdsCsv(),
            // 'sellerId'        => '',
            'includedData' => 'attributes,dimensions,identifiers,images,productTypes,relationships,salesRanks,summaries',
        ])->json();

        if (@$response['numberOfResults'] === 1) {
            return AmazonCatalogItemData::from([
                ...$response['items'][0],
                ...['catalog_data' => $response['items'][0]],
            ]);
        }

        return null;
    }

    /**
     * @throws AmazonTimeoutException
     * @throws ApiException
     * @throws ConnectionException
     */
    public function searchCatalogItems(array $asins): DataCollection
    {
        $response = $this->request(HttpMethodEnum::GET, '/catalog/2022-04-01/items', [
            'identifiers' => implode(',', $asins),
            'identifiersType' => 'ASIN',
            'marketplaceIds' => $this->integrationInstance->integration_settings['catalogMarketplaceId'],
            'includedData' => 'attributes,dimensions,identifiers,images,productTypes,relationships,salesRanks,summaries',
        ])->json();

        return AmazonCatalogItemData::collection($response['items']);
    }
}
