<?php

namespace Modules\Amazon\Services;

use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Services\SalesOrder\Fulfillments\ShipmentDispatcher;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonOutboundFulfillmentManager;

class AmazonOutboundDispatcher implements ShipmentDispatcher
{
    public function dispatchFulfillmentToProvider(SalesOrderFulfillment $fulfillment): void
    {
        $integrationInstance = $fulfillment->warehouse->integrationInstance;
        $amazonIntegrationInstance = AmazonIntegrationInstance::find($integrationInstance->id);

        $manager = new AmazonOutboundFulfillmentManager($amazonIntegrationInstance);

        // Create the order
        $manager->createAmazonFulfillmentOrder($fulfillment);

        $fulfillment->salesOrder()->update(
            ['fulfillment_status' => SalesOrder::FULFILLMENT_STATUS_AWAITING_TRACKING]
        );

        $now = now();

        $fulfillment->update(
            [
                'fulfilled_at'            => $now,
                'status'                  => SalesOrderFulfillment::STATUS_SUBMITTED,
            ]
        );

        $fulfillment->save();

    }
}