<?php

namespace Modules\Amazon\Repositories;

use Modules\Amazon\Data\AmazonNewFbaInboundShipmentItemData;
use Modules\Amazon\Entities\AmazonNewFbaInboundShipmentItem;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\DataCollection;

class AmazonNewFbaInboundShipmentItemRepository
{
    public function save(
        int $shipmentId,
        #[DataCollectionOf(AmazonNewFbaInboundShipmentItemData::class)] DataCollection $data
    ): void
    {
        $data = $data->toCollection();
        $upsertData = $data->map(function (AmazonNewFbaInboundShipmentItemData $item) use ($shipmentId) {
            return [
                'amazon_new_fba_inbound_shipment_id' => $shipmentId,
                'json_object' => json_encode($item->json_object),
            ];
        })->toArray();

        AmazonNewFbaInboundShipmentItem::upsert($upsertData, ['amazon_new_fba_inbound_shipment_id', 'msku']);
    }
}
