<?php

namespace Modules\Amazon\Repositories;

use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Modules\Amazon\Entities\AmazonFinancialEvent;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReportSettlementTypeMapping;

class AmazonFinanceRepository
{

    private function getFromFinancialEventId(mixed $FinancialEventId): ?AmazonFinancialEvent
    {
        /** @var AmazonFinancialEvent $amazonFinancialEvent */
        $amazonFinancialEvent = AmazonFinancialEvent::query()
            ->where('FinancialEventId', $FinancialEventId)
            ->first();

        return $amazonFinancialEvent;
    }

    public function getTypeMappingsForIntegrationInstance(AmazonIntegrationInstance $amazonIntegrationInstance): EloquentCollection
    {
        return AmazonReportSettlementTypeMapping::query()
            ->where('integration_instance_id', $amazonIntegrationInstance->id)
            ->orderBy('financial_code')
            ->get();
    }

    public function mapSettlementTypes(array $mappings): void
    {
        foreach ($mappings as $mapping) {
            $amazonReportSettlementTypeMapping = AmazonReportSettlementTypeMapping::query()->findOrFail($mapping['id']);
            $amazonReportSettlementTypeMapping->update([
                'nominal_code_id' => $mapping['nominal_code_id'],
            ]);
        }
    }
}
