<?php

namespace Modules\Amazon\Repositories;

use Modules\Amazon\Data\AmazonFbaInboundShipmentItemData;
use Modules\Amazon\Entities\AmazonFbaInboundShipmentItem;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\DataCollection;

class AmazonFbaInboundShipmentItemRepository
{
    protected AmazonFbaInboundShipmentRepository $amazonFbaInboundShipmentRepository;

    public function __construct()
    {
        $this->amazonFbaInboundShipmentRepository = app(AmazonFbaInboundShipmentRepository::class);
    }

    public function save(
        int $shipmentId,
        #[DataCollectionOf(AmazonFbaInboundShipmentItemData::class)] DataCollection $data
    ): void
    {
        $data = $data->toCollection();
        $upsertData = $data->map(function (AmazonFbaInboundShipmentItemData $item) use ($shipmentId) {
            return [
                'amazon_fba_inbound_shipment_id' => $shipmentId,
                'json_object' => json_encode($item->json_object),
            ];
        })->toArray();

        AmazonFbaInboundShipmentItem::upsert($upsertData, ['amazon_fba_inbound_shipment_id', 'SellerSKU']);
    }
}
