<?php

namespace Modules\Amazon\Repositories;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\SalesChannelFinancialEventInterface;
use Illuminate\Support\Collection;

abstract class AbstractAmazonFinancialEventRepository
{
    abstract protected static function getModelClassName(): string;

    protected SalesChannelFinancialEventInterface $model;

    public function __construct()
    {
        $this->model = app(static::getModelClassName());
    }

    public function save(IntegrationInstanceInterface $integrationInstance, Collection $orders): void
    {
        $upsertData = $orders->map(function ($order) use ($integrationInstance) {
            return [
                'integration_instance_id' => $integrationInstance->id,
                'json_object' => json_encode($order->json_object),
                'checksum' => $order->checksum,
            ];
        })->toArray();

        $this->model::upsert($upsertData, ['integration_instance_id', $this->model::getTableUniqueId()]);
    }

    public function getEventsWithoutFinancialLines(IntegrationInstanceInterface $integrationInstance): Collection
    {
        return $this->model::doesntHave('financialLines')
            ->where('integration_instance_id', $integrationInstance->id)
            ->whereHas('amazonOrder.salesOrder.salesOrderLines')
            ->with([
                'amazonOrder.orderItems',
                'amazonOrder.salesOrder.salesOrderLines',
            ])
            ->get();
    }
}
