<?php

namespace Modules\Amazon\Observers;

use App\Models\Warehouse;
use App\Models\WarehouseTransferShipmentReceiptLine;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonWarehouseTransferShipmentReceiptLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleting(WarehouseTransferShipmentReceiptLine $warehouseTransferShipmentReceiptLine): void
    {
        $warehouseTransfer = $warehouseTransferShipmentReceiptLine->shipmentReceipt->shipment->warehouseTransfer;
        $fromWarehouse = $warehouseTransfer->fromWarehouse;
        $toWarehouse = $warehouseTransfer->toWarehouse;

        if ($fromWarehouse->type == Warehouse::TYPE_AMAZON_FBA && $toWarehouse->type == Warehouse::TYPE_AMAZON_FBA) {
            $warehouseTransferShipmentReceiptLine->amazonTransferReceiptGroupLine?->delete();
        }
        $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $warehouseTransferShipmentReceiptLine);
    }
}
