<?php

namespace Modules\Amazon\Observers;

use App\Models\WarehouseTransferLine;
use Modules\Amazon\Entities\AmazonFbaReportRemovalOrder;
use Modules\Amazon\Repositories\AmazonLedgerRepository;
use Modules\Amazon\Repositories\AmazonReportRepository;

class AmazonWarehouseTransferLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleted(WarehouseTransferLine $warehouseTransferLine): void
    {
        $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportRemovalOrder, $warehouseTransferLine);
    }
}
