<?php

namespace Modules\Amazon\Observers;

use App\Models\SalesOrderFulfillmentLine;
use App\Services\InventoryManagement\InventoryManager;
use Exception;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonOrder;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonSalesOrderFulfillmentLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    /**
     * @throws Exception
     */
    public function deleted(SalesOrderFulfillmentLine $salesOrderFulfillmentLine): void
    {
        /*
         * FBA orders should not have reserved lines.  We only reserved them once fulfilled and since we are deleting
         * the fulfillment, we are now deleting the inventory movements.
         */
        $salesOrderLine = $salesOrderFulfillmentLine->salesOrderLine;
        $salesOrder = $salesOrderLine->salesOrder;
        if ($salesOrder->order_document instanceof AmazonOrder && $salesOrder->order_document->FulfillmentChannel === 'AFN') {
            $manager = InventoryManager::with($salesOrderFulfillmentLine->salesOrderFulfillment->warehouse_id, $salesOrderLine->product);
            $manager->reverseNegativeEvent($salesOrderLine);
            $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $salesOrderFulfillmentLine);
        }
    }
}
