<?php

namespace Modules\Amazon\Observers;

use App\Models\SalesCreditReturnLine;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonSalesCreditReturnLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleted(SalesCreditReturnLine $salesCreditReturnLine)
    {
        $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $salesCreditReturnLine);
    }
}
