<?php

namespace Modules\Amazon\Observers;

use App\Models\PurchaseOrderShipmentReceiptLine;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonOrder;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonPurchaseOrderShipmentReceiptLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleted(PurchaseOrderShipmentReceiptLine $purchaseOrderShipmentReceiptLine): void
    {
        $shipmentLine = $purchaseOrderShipmentReceiptLine->purchaseOrderShipmentLine;
        $shipment = $shipmentLine->purchaseOrderShipment;
        $purchaseOrder = $shipment->purchaseOrder;
        $warehouse = $purchaseOrder->destinationWarehouse;
        if ($warehouse && $warehouse->integrationInstance?->isAmazonInstance()) {
            $shipmentLine->delete();
            $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $purchaseOrderShipmentReceiptLine);
        }
    }
}
