<?php

namespace Modules\Amazon\Managers;

use InvalidArgumentException;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonRegionManager
{
    public function __construct(private readonly AmazonIntegrationInstance $integrationInstance)
    {
    }

    public function getSellerCentralUrl(): string
    {
        $region = $this->integrationInstance->country;
        return match ($region) {
            'NA' => 'https://sellercentral.amazon.com/',
            'EU' => 'https://sellercentral-europe.amazon.com/',
            default => throw new InvalidArgumentException("Region $region is not supported"),
        };
    }

    public function getMarketplaceIds(): array
    {
        $marketplaces = $this->integrationInstance->integration_settings['marketplaces'];

        return collect($marketplaces)->map(function ($marketplace) {
            return $marketplace['marketplace']['id'];
        })->toArray();
    }
}