<?php

namespace Modules\Amazon\Jobs;

use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonFinancialEventGroup;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonFinanceManager;

class SyncAmazonFinancialEventsJob extends AmazonJob implements ShouldQueue
{
    public string $uniqueId;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected ?AmazonFinancialEventGroup $amazonFinancialEventGroup = null,
        protected ?Carbon $postedAfter = null
    ) {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * Get amazon orders.
     *
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        return (new AmazonFinanceManager($this->amazonIntegrationInstance))
            ->syncFinancialEvents($this->amazonFinancialEventGroup, $this->postedAfter, @$this->jobPayload['nextToken']);
    }
}
