<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonFinanceManager;
use Throwable;

class SeedAmazonReportSettlementDataTypeMappingsJob extends AmazonBaseJob
{
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonFinanceManager($this->amazonIntegrationInstance))->seedTypeMappings();
    }
}
