<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetReportsAdt;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonReportManager;

class RefreshAmazonSettlementReportsJob extends AmazonJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected AmazonGetReportsAdt $parameters = new AmazonGetReportsAdt(AmazonReportTypeEnum::SETTLEMENT_REPORT),
    ) {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * Get amazon orders.
     *
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        $this->parameters->nextToken = @$this->jobPayload['nextToken'];

        return (new AmazonReportManager($this->amazonIntegrationInstance))
            ->refreshSettlementReports($this->parameters);
    }
}
