<?php

namespace Modules\Amazon\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonOutboundFulfillmentManager;

class RefreshAmazonOutboundFulfillmentsJob extends AmazonJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly AmazonIntegrationInstance $integrationInstance, private readonly ?string $queryStartDate = null)
    {
    }

    /**
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData|ClientResponseDataInterface
    {
        return (new AmazonOutboundFulfillmentManager($this->integrationInstance))->refreshOutboundFulfillments($this->queryStartDate, @$this->jobPayload['nextToken']);
    }
}
