<?php

namespace Modules\Amazon\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetOrdersAdt;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonOrderManager;

class RefreshAmazonOrdersJob extends AmazonJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected AmazonGetOrdersAdt $parameters,
    ) {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData|ClientResponseDataInterface
    {
        $this->parameters->nextToken = @$this->jobPayload['nextToken'];

        return (new AmazonOrderManager($this->amazonIntegrationInstance))->refreshOrders($this->parameters);
    }
}
