<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetInboundShipmentItemsAdt;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonNewInboundManager;

class RefreshAmazonNewFbaInboundShipmentItemsJob extends AmazonJob
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;


    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected AmazonGetInboundShipmentItemsAdt $parameters,
    )
    {}

    /**
     * @throws Exception
     * @throws BindingResolutionException
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        (new AmazonNewInboundManager($this->amazonIntegrationInstance))->getShipmentItems($this->parameters);

        return AmazonResponseData::from([
            'collection' => collect(),
        ]);
    }
}
