<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonInboundManager;

class RefreshAmazonFbaInboundShipmentItemsJob extends AmazonJob
{
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance, protected string $shipmentId)
    {
    }

    /**
     * @throws Exception
     * @throws BindingResolutionException
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        (new AmazonInboundManager($this->amazonIntegrationInstance))->refreshShipmentItems([$this->shipmentId]);

        return AmazonResponseData::from([
            'nextToken' => null,
            'collection' => collect(),
        ]);
    }
}
