<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonInboundManager;
use Modules\Amazon\Managers\AmazonNewInboundManager;

class RefreshAmazonFbaInboundPlanItemsJob extends AmazonJob implements ShouldBeUnique
{
    protected string $uniqueId;

    public int $uniqueFor = 60 * 5;

    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance, protected string $planId)
    {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id.':'.$planId;
    }

    /**
     * @throws Exception
     * @throws BindingResolutionException
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        (new AmazonNewInboundManager($this->amazonIntegrationInstance))->refreshPlanItems([$this->planId]);

        return AmazonResponseData::from([
            'nextToken' => null,
            'collection' => collect(),
        ]);
    }
}
