<?php

namespace Modules\Amazon\Jobs;

use App\Models\TaskStatus\TaskStatus;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Actions\AmazonProductImporter;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

/**
 * Class ImportProductMapping.
 */
class ImportProductMapping implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $filePath;

    /**
     * @var AmazonIntegrationInstance
     */
    protected $amazonIntegrationInstance;

    /**
     * @var TaskStatus
     */
    protected $task;

    /**
     * ImportListingMapping constructor.
     */
    public function __construct(AmazonIntegrationInstance $amazonIntegrationInstance, $filePath, TaskStatus $task)
    {
        $this->amazonIntegrationInstance = $amazonIntegrationInstance;
        $this->filePath = $filePath;
        $this->task = $task;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        set_time_limit(0);

        $importer = new AmazonProductImporter($this->task, $this->filePath, $this->amazonIntegrationInstance);

        $importer->import();
    }
}
