<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Broadcasting\ShouldBeUnique;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Managers\AmazonLedgerManager;
use Throwable;

class CreateAuditTrailFromAmazonLedgerJob extends AmazonBaseJob implements ShouldBeUnique
{
    protected ?AmazonReport $amazonReport;

    public function uniqueId(): string
    {
        return $this->amazonIntegrationInstance->id.'-'.$this->amazonReport?->id;
    }

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance, ?AmazonReport $amazonReport = null)
    {
        $this->amazonReport = $amazonReport;
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonLedgerManager($this->amazonIntegrationInstance))->reconcileLedgers($this->amazonReport);
    }
}
