<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Support\Collection;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Repositories\AmazonProductRepository;
use Throwable;

class CreateAmazonSearchCatalogItemsJobsJob extends AmazonBaseJob
{
    protected AmazonProductRepository $amazonProductRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->onQueue('sales-channels');
        $this->amazonProductRepository = app(AmazonProductRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        customlog('amazon', 'Creating get catalog item jobs');

        $this->amazonProductRepository
            ->getProductsMissingCatalogItem($this->amazonIntegrationInstance)
            ->chunk(20)
            ->each(function (Collection $amazonProducts) {
                static $delay = 0;
                dispatch(new SearchAmazonCatalogItemsJob($this->amazonIntegrationInstance, $amazonProducts))->delay($delay)->onQueue('sales-channels');
                $delay = 1;
            });

        /*
         * TODO: Ideally after all the get catalog item jobs finish, we would run the create sku products, but not sure how to
         *  do this since there are multiple jobs and not in a chain or batch.  In the meantime, I can schedule
         *  a create sku products job to run every 5 minutes
         */
    }
}
