<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Actions\CreateAmazonReport;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Repositories\AmazonReportRepository;
use Throwable;

class CreateAmazonReportJob extends AmazonJob implements ShouldBeUnique
{
    protected AmazonReportRepository $reportRepository;

    public int $uniqueFor = 60 * 5;

    /**
     * Create a new job instance.
     *
     * @return void
     *
     * @throws Exception
     */
    public function __construct(protected int $amazonReportRequestId)
    {
        $this->reportRepository = app(AmazonReportRepository::class);
    }

    public function uniqueId(): string
    {
        return "amazon-report-request-$this->amazonReportRequestId";
    }

    /**
     * @throws Throwable
     */
    public function apiCall(): AmazonResponseData
    {
        if ($amazonReportRequest = $this->reportRepository->getRequestFromId($this->amazonReportRequestId)) {
            (new CreateAmazonReport($amazonReportRequest))->handle();
        }

        return AmazonResponseData::from([
            'collection' => collect(),
            'nextToken' => null,
        ]);
    }
}
