<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetInboundShipmentAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonNewInboundManager;
use Modules\Amazon\Repositories\AmazonNewFbaInboundPlanRepository;
use Throwable;

class CreateAmazonRefreshFbaInboundShipmentsJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private AmazonNewFbaInboundPlanRepository $plans;

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->plans = app(AmazonNewFbaInboundPlanRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $shipments = $this->plans->getShipmentsNeedingDetails($this->amazonIntegrationInstance);

        foreach ($shipments as $planId => $shipmentIds) {
            foreach ($shipmentIds as $shipmentId) {
                $parameters = new AmazonGetInboundShipmentAdt(
                    planId: $planId,
                    shipmentId: $shipmentId
                );
                RefreshAmazonFbaInboundShipmentJob::dispatch($this->amazonIntegrationInstance, $parameters);
            }
        }

        dispatch(new CreateAmazonRefreshNewFbaInboundShipmentItemsJobs($this->amazonIntegrationInstance));

        (new AmazonNewInboundManager($this->amazonIntegrationInstance))->transitionLegacyShipments();
        AmazonProcessUnprocessedNewInboundShipmentsJob::dispatch($this->amazonIntegrationInstance);
        AmazonProcessNewInboundShipmentCancellationsJob::dispatch($this->amazonIntegrationInstance);
    }
}
