<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Repositories\AmazonFbaInboundShipmentRepository;
use Throwable;

class CreateAmazonRefreshFbaInboundShipmentItemsJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private AmazonFbaInboundShipmentRepository $amazonFbaInboundShipmentRepository;

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->amazonFbaInboundShipmentRepository = app(AmazonFbaInboundShipmentRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $shipmentIds = $this->amazonFbaInboundShipmentRepository->getActiveItemlessShipmentIds();

        $shipmentIds->each(function (string $shipmentId) {
            RefreshAmazonFbaInboundShipmentItemsJob::dispatch($this->amazonIntegrationInstance, $shipmentId);
        });
    }
}
