<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Broadcasting\ShouldBeUnique;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Managers\AmazonFnskuProductManager;
use Throwable;

class CreateAmazonFnSkusToSkuProductsJob extends AmazonBaseJob implements ShouldBeUnique
{
    protected ?AmazonReport $amazonReport;

    public function uniqueId(): string
    {
        return $this->amazonIntegrationInstance->id.'-'.$this->amazonReport?->id;
    }

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance, ?AmazonReport $amazonReport = null)
    {
        $this->amazonReport = $amazonReport;
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonFnskuProductManager($this->amazonIntegrationInstance))->generateFnskuProducts($this->amazonReport);
    }
}
