<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonRemovalOrderManager;
use Throwable;

class AmazonProcessUnprocessedRemovalOrdersJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly AmazonIntegrationInstance $amazonIntegrationInstance)
    {}

    /**
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonRemovalOrderManager($this->amazonIntegrationInstance))->processUnprocessed();
    }
}
