<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonReportSettlementData;

/**
 * @mixin AmazonReportSettlementData
 */
class AmazonReportSettlementDataResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'FinancialEventGroupId' => $this->inclusive('FinancialEventGroupId', $this->amazonFinancialEventGroup->FinancialEventGroupId),
            'settlement_id' => $this->inclusive('settlement_id', $this->settlement_id),
            'posted_date_time' => $this->inclusive('posted_date_time', $this->posted_date_time),
            'posted_date' => $this->inclusive('posted_date', $this->posted_date),
            'transaction_type' => $this->inclusive('transaction_type', $this->transaction_type),
            'amount_type' => $this->inclusive('amount_type', $this->amount_type),
            'amount' => $this->inclusive('amount', $this->amount),
            'amount_description' => $this->inclusive('amount_description', $this->amount_description),
            'quantity_purchased' => $this->inclusive('quantity_purchased', $this->quantity_purchased),
            'sku' => $this->inclusive('sku', $this->sku),
            'marketplace_name' => $this->inclusive('marketplace_name', $this->marketplace_name),
            'order_id' => $this->inclusive('order_id', $this->order_id),
            'merchant_order_id' => $this->inclusive('merchant_order_id', $this->merchant_order_id),
            'adjustment_id' => $this->inclusive('adjustment_id', $this->adjustment_id),
            'shipment_id' => $this->inclusive('shipment_id', $this->shipment_id),
            'fulfillment_id' => $this->inclusive('fulfillment_id', $this->fulfillment_id),
            'order_item_code' => $this->inclusive('order_item_code', $this->order_item_code),
            'merchant_order_item_id' => $this->inclusive('merchant_order_item_id', $this->merchant_order_item_id),
            'merchant_adjustment_item_id' => $this->inclusive('merchant_adjustment_item_id', $this->merchant_adjustment_item_id),
            'promotion_id' => $this->inclusive('promotion_id', $this->promotion_id),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
