<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\NewDataTableResource;
use Modules\Amazon\Entities\AmazonNewFbaInboundShipment;

/**
 * @mixin AmazonNewFbaInboundShipment
 */
class AmazonNewFbaInboundShipmentResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        $skuLink = $this->sku_link;
        if($skuLink) {
            $skuLinkName = $skuLink->{$skuLink::getNumberFieldName()};
        }
        else {
            $skuLinkName = null;
        }
        return [
            'sku_link' => $this->whenLoaded('sku_link', [
                'id' => $this->sku_link_id,
                'type' => $this->sku_link_type,
                'name' => $skuLinkName,
                'displayType' => convertFQNToFriendlyName($this->sku_link_type),
            ]),
            'ledgers' => $this->whenLoaded('ledgers', function () {
                return $this->ledgers;
            }),
            'items' => $this->inclusive('items', $this->whenLoaded('amazonFbaInboundShipmentItems', function () {
                return AmazonNewFbaInboundShipmentItemResource::collection($this->amazonFbaInboundShipmentItems);
            })),
            'destinationAddress' => $this->destination['address'],
        ];
    }
//
//    /**
//     * Transform the resource into an array.
//     */
//    public function toArray(Request $request): array
//    {
//        $skuLink = $this->sku_link;
//        if($skuLink) {
//            $skuLinkName = $skuLink->{$skuLink::getNumberFieldName()};
//        }
//        else {
//            $skuLinkName = null;
//        }
//        return [
//            'id' => $this->id,
//            'shipmentId' => $this->inclusive('shipmentId', $this->shipmentId),
//            'shipmentConfirmationId' => $this->inclusive('shipmentConfirmationId', $this->shipmentConfirmationId),
//            'name' => $this->inclusive('name', $this->name),
//            'sourceName' => $this->inclusive('sourceName', $this->sourceName),
//            'source' => $this->inclusive('source', $this->source),
//            'destination' => $this->inclusive('destination', $this->destination),
//            'status' => $this->inclusive('status', $this->status),
//            'plan' => $this->inclusive('plan', $this->amazonFbaInboundPlan->toArray()),
//            //'boxes' => $this->inclusive('boxes', $this->),
//            'errorLog' => $this->inclusive('errorLog', $this->errorLog),
//            'is_before_initial_count' => $this->inclusive('is_before_initial_count', $this->is_before_initial_count),
//            'sku_link' => $this->inclusive('sku_link', [
//                'id' => $this->sku_link_id,
//                'type' => $this->sku_link_type,
//                'name' => $skuLinkName,
//                'displayType' => convertFQNToFriendlyName($this->sku_link_type),
//            ]),
//            'ledgers' => $this->whenLoaded('ledgers', function () {
//                return $this->ledgers;
//            }),
//            'created_at' => $this->inclusive('created_at', $this->created_at),
//            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
//            'items' => $this->inclusive('items', $this->whenLoaded('amazonFbaInboundShipmentItems', function () {
//                return AmazonNewFbaInboundShipmentItemResource::collection($this->amazonFbaInboundShipmentItems);
//            })),
//        ];
//    }
}
