<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\NewDataTableResource;
use Illuminate\Support\Collection;
use Modules\Amazon\Entities\AmazonFnskuProduct;

/**
 * @mixin AmazonFnskuProduct
 */
class AmazonFnskuProductResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'product' => $this->inclusive('product', $this->product?->only('id', 'sku', 'name')),
            'initialInventory' => $this->inclusive('initialInventory', $this->whenLoaded(
                'amazonFbaInitialInventory',
                AmazonFbaInitialInventoryResource::make($this->amazonFbaInitialInventory)
            )),
            'ledgers' => $this->inclusive('ledgers', $this->whenLoaded(
                'amazonFbaReportInventoryLedgers',
                AmazonFbaReportInventoryLedgerResource::collection($this->amazonFbaReportInventoryLedgers ?? new Collection())
            )),
        ];
    }
}
