<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\NewDataTableResource;
use App\Models\WarehouseTransferLine;
use Modules\Amazon\Entities\AmazonFbaReportRemovalOrder;

/**
 * @mixin AmazonFbaReportRemovalOrder
 */
class AmazonFbaReportRemovalOrderResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'skuLink' => $this->whenLoaded('sku_link', function () {
                $skuLinkParent = $this->sku_link_type == WarehouseTransferLine::class ? $this->sku_link->warehouseTransfer : null; // TO implement;
                return [
                    'id' => $skuLinkParent->id,
                    'type' => get_class($skuLinkParent),
                    'name' => $skuLinkParent->warehouse_transfer_number,
                    'displayType' => convertFQNToFriendlyName(get_class($skuLinkParent)),
                ];
            }),
            'amazonProduct' => $this->whenLoaded('amazonProduct', [
                'id' => $this->amazonProduct?->id,
            ]),
            'fnskuProduct' => $this->whenLoaded('amazonFnskuProduct', [
                'id' => $this->amazonFnskuProduct?->id,
            ]),
        ];
    }
}
