<?php

namespace Modules\Amazon\Http\Resources;

use App\Models\Warehouse;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Entities\AmazonFbaInboundShipmentItem;
use Modules\Amazon\Entities\AmazonFnskuProduct;

/**
 * @mixin AmazonFbaInboundShipmentItem
 */
class AmazonFbaInboundShipmentItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $fnskuProduct = $this->getFnskuProduct();
        if ($fnskuProduct) {
            $product = $fnskuProduct->product;
            $shipFromMapping = $this->amazonFbaInboundShipment->shipFromMapping;
            if ($shipFromMapping->link_type == Warehouse::class) {
                $inventory_available = $product?->productInventory->where('warehouse_id', $this->amazonFbaInboundShipment->shipFromMapping->link_id)?->first()?->inventory_available ?? 0;
            } else {
                $inventory_available = null;
            }
            $fnskuData = [
                'id' => $fnskuProduct->id,
                'fnsku' => $fnskuProduct->fnsku,
                'location' => $fnskuProduct->location,
                'product' => [
                    'id' => $product?->id,
                    'name' => $product?->name,
                    'sku' => $product?->sku,
                    'inventory_available' => $inventory_available,
                ]
            ];
        } else {
            $fnskuData = null;
        }
        return [
            'SellerSKU' => $this->SellerSKU,
            'FulfillmentNetworkSKU' => $this->FulfillmentNetworkSKU,
            'QuantityShipped' => $this->QuantityShipped,
            'item_name' => $this->amazonProduct?->item_name,
            'item_asin' => $this->amazonProduct?->asin1,
            'fnsku_product'  => $fnskuData,
        ];
    }
}
