<?php

namespace Modules\Amazon\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Entities\AmazonFbaInboundShipFromMapping;

/**
 * @mixin AmazonFbaInboundShipFromMapping
 */
class AmazonFbaInboundShipFromMappingResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'link_id' => $this->link_id,
            'link_type' => $this->link_type,
            'link_name' => $this->link?->name,
        ];
    }
}
