<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlan;

/**
 * @mixin AmazonNewFbaInboundPlan
 */
class AmazonFbaInboundPlanResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'inboundPlanId' => $this->inclusive('inboundPlanId', $this->inboundPlanId),
            'name' => $this->inclusive('name', $this->name),
            'status' => $this->inclusive('status', $this->status),
            'lastUpdatedAt' => $this->inclusive('lastUpdatedAt', $this->lastUpdatedAt),
            'createdAt' => $this->inclusive('createdAt', $this->createdAt),
            'sourceAddress' => $this->inclusive('sourceAddress', $this->json_object['sourceAddress']),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'items' => $this->inclusive('items', $this->whenLoaded('amazonNewFbaInboundPlanItems', function () {
                return AmazonFbaInboundPlanItemResource::collection($this->amazonNewFbaInboundPlanItems);
            })),
        ];
    }
}
